<?php

namespace App\Http\Controllers\Admin;

use App\Models\Admin;
use Spatie\Permission\Models\Permission;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AdminController extends Controller
{
   
      // GET /admin/admins
    public function index()
    {
        $admins = Admin::with('permissions')->get();
        return view('admin.pages.permitions.admins', compact('admins'));

    }

    // POST /admin/admins
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'email' => 'required|email|unique:admins,email',
            'password' => 'required|string|min:6',
            'permissions' => 'nullable|array'
        ]);

        $admin = Admin::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);
        // اعطاء الصلاحيات مباشرة
     
        if ($request->has('permissions')) {
            // استدعاء الصلاحيات بالكائن
            $permissions = Permission::whereIn('id', $request->permissions)
                                    ->where('guard_name', 'admin')
                                    ->get(); // نحصل على كائنات Permission

            $admin->givePermissionTo($permissions); // الآن يحفظ الـ permission_id في جدول model_has_permissions
        }
       return redirect()->back()->with('success', 'تم إضافة المسؤل بنجاح');

        
    }

    // PUT /admin/admins/{id}
    public function update(Request $request, $id)
    {
        $admin = Admin::findOrFail($id);

        $request->validate([
            'name' => 'sometimes|required|string',
            'email' => 'sometimes|required|email|unique:admins,email,'.$id,
            'password' => 'nullable|string|min:6',
            'permissions' => 'nullable|array'
        ]);

        $admin->update([
            'name' => $request->name ?? $admin->name,
            'email' => $request->email ?? $admin->email,
            'password' => $request->password ? Hash::make($request->password) : $admin->password,
        ]);

        // تحديث الصلاحيات
      if ($request->has('permissions')) {
            $names = Permission::whereIn('id', $request->permissions)
                            ->pluck('name')
                            ->toArray();
            $admin->syncPermissions($names);
       } // or givePermissionTo($names)


        return redirect()
            ->back()
            ->with('success','تم تحديث بيانات المسؤول بنجاح');
    }
  public function create()
{
    $permissions = Permission::all();
    return view('admin.pages.permitions.add_admin', compact('permissions'));
}
    public function edit($id)
    {
        $admin = Admin::findOrFail($id);
        $permissions = Permission::where('guard_name','admin')->get();
        $adminPermissions = $admin->permissions->pluck('id')->toArray(); // IDs الحالية

        return view('admin.pages.permitions.edit_admin', compact('admin','permissions','adminPermissions'));
    }
   
}