<?php

namespace App\Http\Controllers\Admin;

use Storage;
use App\Models\Brand;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\File;

class CarBrandController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $brands = Brand::all();
        return view('admin.pages.car_brand.index', compact('brands'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.pages.car_brand.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
               
            ]);

           
            $imagePath = null;
            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $fileName = time() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('storage/brands'), $fileName);
            
                $imagePath = 'brands/' . $fileName; // relative path
            }

            $category = Brand::create([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
                 'image'=>$imagePath,
                                 'is_active'=>$request->is_active,

            ]);

            return redirect()->route('admin.carbrand.index')->with('success', 'تم إنشاء البراند بنجاح');
        } catch (\Exception $e) {
            Log::error('Error storing category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage().'حدث خطأ أثناء إنشاء البراند. حاول مرة أخرى.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $brands = Brand::findOrFail($id);
        return view('admin.pages.category.show', compact('brands'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $brand = Brand::findOrFail($id);
        return view('admin.pages.car_brand.edit', compact('category', 'brand'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
              
            ]);

            $category = Brand::findOrFail($id);
             $imagePath = $category->image;
            if ($request->hasFile('image')) {
                     // remove old one if exists
                    if (!empty($imagePath) && File::exists(public_path($imagePath))) {
                        File::delete(public_path($imagePath));
                    }

                    // save new one
                    $file = $request->file('image');
                    $fileName = time() . '.' . $file->getClientOriginalExtension();
                    $file->move(public_path('storage/brands'), $fileName);

                    $imagePath = 'brands/' . $fileName;
                    
                    
            }

            $category->update([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
                'image'=>$imagePath,
                'active'=>$request->is_active,
            ]);

            return redirect()->route('admin.carbrand.index')->with('success', 'تم تحديث البراند بنجاح');
        } catch (\Exception $e) {
            Log::error('Error updating category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', 'حدث خطأ أثناء تحديث البراند. حاول مرة أخرى.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id,Request $request)
    {
      /*   try {
            $category = Brand::findOrFail($id);

           

            $category->delete();

            return redirect()->route('admin.carbrand.index')->with('success', 'تم حذف البراند بنجاح');
        } catch (\Exception $e) {
            Log::error('Error deleting category: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء حذف البراند. حاول مرة أخرى.');
        } */
        try {
             if($request->input('ids')){
                  $ids = $request->input('ids');
               
                if (!$ids || !is_array($ids) || count($ids) === 0) {
                    return redirect()->back()->with('error', 'لم يتم تحديد أي البراند للحذف');
                }

                $brands = \App\Models\Brand::whereIn('id', $ids)->get();

                if ($brands->isEmpty()) {
                    return redirect()->back()->with('error', 'لم يتم العثور على البراندات المحددين');
                }

                \App\Models\Brand::whereIn('id', $ids)->delete();

                return redirect()->back()->with('success', 'تم حذف البراندات المحددين بنجاح');
             }


            $brand = Brand::findOrFail($id);

           


            $brand->delete();

            return redirect()->back()->with('success', 'تم حذف البراند بنجاح');
        } catch (\Exception $e) {
            Log::error('Error deleting merchant: ' . $e->getMessage());
            return redirect()->back()->with('error', $e->getMessage() . 'حدث خطأ أثناء حذف البراند. حاول مرة أخرى.');
        }
    }


      public function bulkDelete(Request $request)
    {
       
       
         dd($request->all());
        
        // Delete merchants
        \App\Models\Brand::whereIn('id', $ids)->delete();

        return redirect()->back()->with('success', 'تم حذف البراندات المحددين بنجاح');
     }
}