<?php

namespace App\Http\Controllers\Admin;

use Storage;
use App\Models\CarCategory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class CarCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $categories = CarCategory::all();
        return view('admin.pages.car_category.index', compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.pages.car_category.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
               
            ]);

           

            $category = CarCategory::create([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
              
            ]);

            return redirect()->route('admin.carcategory.index')->with('success', 'تم إنشاء القسم بنجاح');
        } catch (\Exception $e) {
            Log::error('Error storing category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage().'حدث خطأ أثناء إنشاء القسم. حاول مرة أخرى.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $category = CarCategory::findOrFail($id);
        return view('admin.pages.category.show', compact('category'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $category = CarCategory::findOrFail($id);
        $categories = CarCategory::all();
        return view('admin.pages.car_category.edit', compact('category', 'categories'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
              
            ]);

            $category = CarCategory::findOrFail($id);

           

            $category->update([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
               
            ]);

            return redirect()->route('admin.carcategory.index')->with('success', 'تم تحديث القسم بنجاح');
        } catch (\Exception $e) {
            Log::error('Error updating category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', 'حدث خطأ أثناء تحديث القسم. حاول مرة أخرى.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        try {
            $category = CarCategory::findOrFail($id);

           

            $category->delete();

            return redirect()->route('admin.carcategory.index')->with('success', 'تم حذف القسم بنجاح');
        } catch (\Exception $e) {
            Log::error('Error deleting category: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء حذف القسم. حاول مرة أخرى.');
        }
    }
}