<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\CarModel;
use App\Models\CarStyle;
use App\Models\City;
use App\Models\CarForSale;
use App\Notifications\WinchRequestNotification;
use Illuminate\Http\Request;

class CarMarketController extends Controller
{
    public function index()
    {
        $cars = CarForSale::latest()->get();
     
        return view('admin.pages.car_market.index', compact('cars'));
    }

   public function create()
    {
        $models = CarModel::all();
        $styles = CarStyle::all();
        $cities = City::all();
        $users = User::all(); // Optional, if needed for admin
        return view('admin.pages.car_market.craete', compact('models', 'styles', 'cities', 'users'));
    }

public function store(Request $request)
{
    try {
        $request->validate([
            'model_id' => 'required',
            'price' => 'required|numeric',
            'mileage' => 'required|numeric',
            'description' => 'required|string',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:2048',
            'phone_number' => 'required|string',
            'transmission_type' => 'required',
            'production_year' => 'required|numeric',
            'city_id' => 'required',
            'style_id' => 'required',
            'installment_available' => 'required|boolean',
            'negotiability' => 'required|boolean',
            'is_active' => 'nullable|boolean',
            'is_whatsapp' => 'nullable|boolean',
            'user_id' => 'required|exists:users,id',
        ]);

        $data = $request->all();

        // Handle image upload
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('storage/car_for_sale'), $filename);
            $data['image'] = 'car_for_sale/' . $filename;
        }

        CarForSale::create($data);

        return redirect()->back()->with('success', 'تم إضافة السيارة بنجاح');
    } catch (Exception $e) {
        // Log the error (optional but recommended for debugging)
        Log::error('CarForSale Store Error: ' . $e->getMessage());

        return redirect()->back()->with('error', 'حدث خطأ أثناء إضافة السيارة. الرجاء المحاولة مرة أخرى.');
    }
}

    public function edit(Winch $winch)
    {
        $users = User::select('id', 'full_name')->get();
        return view('admin.winches.edit', compact('winch', 'users'));
    }

    

    public function destroy( $id)
    {
    
        $car=CarForSale::findOrFail($id);
      
        $car->delete();
        return redirect()->route('admin.car_sales.index')->with('success', 'تم حذف طلب السيارة من التسوق  بنجاح.');
    }
    public function update(Request $request,  $id)
    {
        $car=CarForSale::findOrFail($id);
       
        $request->validate([
            'status' => 'required',
        ]);
        
        $car->update([
            'is_active' => (int) $request->status,
        ]);

       

        return redirect()->route('admin.car_sales.index')->with('success', 'تم تحديث حالة  السيارة واضافتها الي التسوق بنجاح.');
    }
}
