<?php

namespace App\Http\Controllers\Admin;

use Storage;
use App\Models\CarCategory;
use App\Models\Brand;
use App\Models\CarModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class CarModelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $models = CarModel::latest()->with('brand')->get();
        $brands=Brand::all();
        $carcategories=CarCategory::all();
        return view('admin.pages.car_model.index', compact('models','brands','carcategories'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
         $brands=Brand::all();
        $carcategories=CarCategory::all();
        return view('admin.pages.car_model.add',compact('brands','carcategories'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
               
            ]);
            

           

            $category = CarModel::create([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
                'brand_id' =>$request->brand_id,
                //'car_category_id' =>$request->car_category_id,
                'year'=>$request->year_from . '_' .$request->year_to,
                
              
            ]);

            return redirect()->back()->with('success', 'تم إنشاء الموديل بنجاح');
        } catch (\Exception $e) {
            Log::error('Error storing category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage().'حدث خطأ أثناء إنشاء القسم. حاول مرة أخرى.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $category = CarModel::findOrFail($id);
        return view('admin.pages.car_model.show', compact('category'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $category = CarModel::findOrFail($id);
        $categories = CarModel::all();
         if ($category->year) {
            [$year_from, $year_to] = explode('_', $category->year);
        } else {
            $year_from = $year_to = null;
        }
        return view('admin.pages.car_model.edit', compact('category', 'categories','year_from','year_to'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
      
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
              
            ]);

            $category = CarModel::findOrFail($id);

           

            $category->update([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
                 'year'=>$request->year_from . '_' .$request->year_to,
                 'active'=>$request->is_active,
                 'brand_id'=>$request->brand_id,
               
            ]);

            return redirect()->route('admin.carmodel.index')->with('success', 'تم تحديث الموديل بنجاح');
        } catch (\Exception $e) {
            Log::error('Error updating category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', 'حدث خطأ أثناء تحديث القسم. حاول مرة أخرى.'. $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        try {
            $category = CarModel::findOrFail($id);

           

            $category->delete();

            return redirect()->route('admin.carmodel.index')->with('success', 'تم حذف القسم بنجاح');
        } catch (\Exception $e) {
            Log::error('Error deleting category: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء حذف القسم. حاول مرة أخرى.');
        }
    }
}