<?php
namespace App\Http\Controllers\Admin;

use Exception;
use Carbon\Carbon;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Resources\AppointmentResource;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\FillterResource;
use App\Http\Resources\ContactUsIconResource;
use App\Models\CategoryFilter;
use App\Models\Category;
use Illuminate\Validation\ValidationException;

use App\Traits\ApiTrait;
 
class CategoryFilterController extends Controller
{
 use ApiTrait; 
  public function index()

  {
        $categories=Category::all();
    
     $filters = CategoryFilter::all();
     return view('admin.pages.category_filters.index', compact('filters','categories'));  
    
  }
    public function create()
    {
        $categories=Category::all();
        return view('admin.pages.category_filters.add',compact('categories'));
    }

      public function store(Request $request)
    {
        $request->validate([
            'key_ar' => 'required|string|max:255',
            'key_en' => 'required|string|max:255',
            'category_id' => 'required|exists:categories,id',
            'data_type_ar' => 'nullable|string|max:255',
            'data_type_en' => 'nullable|string|max:255',
        ]);

        $filter = new CategoryFilter();
        $filter->setTranslations('key', [
            'ar' => $request->key_ar,
            'en' => $request->key_en,
        ]);
        $filter->setTranslations('data_type', [
            'ar' => $request->data_type_ar,
            'en' => $request->data_type_en,
        ]);
        $filter->category_id = $request->category_id;
        $filter->save();

        return redirect()->route('admin.filters.index')->with('success', 'تم إضافة الخاصية بنجاح');
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'key_ar' => 'required|string|max:255',
            'key_en' => 'required|string|max:255',
            'category_id' => 'required|exists:categories,id',
        ]);

        $filter = CategoryFilter::findOrFail($id);

        $filter->setTranslations('key', [
            'ar' => $request->key_ar,
            'en' => $request->key_en,
        ]);
        
        $filter->setTranslations('data_type', [
            'ar' => $request->data_type_ar,
            'en' => $request->data_type_en,
        ]);
        $filter->category_id = $request->category_id;
        $filter->save();

        return redirect()->route('admin.filters.index')->with('success', 'تم تحديث الخاصية بنجاح');
    }

    public function destroy($id)
    {
        $filter = CategoryFilter::findOrFail($id);
        $filter->delete();

        return redirect()->route('admin.filters.index')->with('success', 'تم حذف الخاصية بنجاح');
    }
}



