<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use Illuminate\Http\Request;
use App\Mail\ContactResponseMail;
use Illuminate\Support\Facades\Mail;
class ContactMessageController extends Controller
{
    public function index()
    {
        $contacts = Contact::latest()->get();
        return view('admin.pages.contact.index', compact('contacts'));
    }

   public function update(Request $request, Contact $contact)
    {
        $request->validate([
            'notes' => 'nullable|string',
        ]);

        $contact->update([
            'notes' => $request->notes,
        ]);

        if ($contact->email) {
            Mail::to($contact->email)->send(new ContactResponseMail($contact, $request->notes));
        }

        return redirect()->route('admin.contacts.index')->with('success', 'تم تحديث الرسالة وإرسال الرد بنجاح');
    }
    public function destroy(Contact $contact)
    {
        $contact->delete();
        return redirect()->route('admin.contacts.index')->with('success', 'تم حذف الرسالة بنجاح');
    }
}
