<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CustomPartRequest;
use Illuminate\Http\Request;
use App\Services\UserNotificationService;

class CustomePartController extends Controller
{

    public function index()
    {
        $requests = CustomPartRequest::with('user')->latest()->get();
        return view('admin.pages.custompart.index', compact('requests'));
    }

    public function showItems($id)
    {
        $request = CustomPartRequest::with(['items.itemOffers.vendor'])->findOrFail($id);
        return view('admin.pages.custompart.item', compact('request'));
    }

    public function update(Request $request, $id)
    {
        $req = CustomPartRequest::findOrFail($id);
        $req->update(['status' => $request->status]);

          $userNotifier = new UserNotificationService();

            $userNotifier->requestChangeStatus(
                $req->user->id,
                $req->id,
                $request->status
             );
        return back()->with('success', 'تم تحديث الملاحظات بنجاح');
    }

}
