<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Governorate;
use Illuminate\Http\Request;

class GovernateController extends Controller
{
    // ✅ List all governorates
    public function index()
    {
        $governorates = Governorate::all();
        return view('admin.pages.governate.index', compact('governorates'));
    }

    // ✅ Show form to create new governorate (optional if using modal)
    public function create()
    {
        return view('admin.pages.governate.create');
    }

    // ✅ Store new governorate
    public function store(Request $request)
    {
        $request->validate([
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
           
        ]);

        Governorate::create([
            'name' => [
                'ar' => $request->name_ar,
                'en' => $request->name_en,
            ],
           
        ]);

        return redirect()->back()->with('success', 'تمت إضافة المحافظة بنجاح');
    }

    // ✅ Show form to edit
    public function edit(Governorate $governorate)
    {
        return view('admin.pages.governate.edit', compact('governorate'));
    }

    // ✅ Update governorate
    public function update(Request $request, Governorate $governorate)
    {
        $request->validate([
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
           
        ]);

        $governorate->update([
            'name' => [
                'ar' => $request->name_ar,
                'en' => $request->name_en,
            ],
          
        ]);

        return redirect()->back()->with('success', 'تم تعديل المحافظة بنجاح');
    }

    // ✅ Delete governorate
    public function destroy(Governorate $governorate)
    {
        $governorate->delete();
        return redirect()->back()->with('success', 'تم حذف المحافظة بنجاح');
    }
}
