<?php

namespace App\Http\Controllers\Admin;

use Storage;
use App\Models\Inspection;
use App\Models\Specialty;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class InceptionController extends Controller
{
   
    public function index()
    {
        $inceptions = Inspection::with('speclity')->get();
        $spiclizations = Specialty::with('inceptions')->get();
        return view('admin.pages.inceptions.index', compact('spiclizations','inceptions'));
    }

   

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
     
        try {
             $request->validate([
            'title_ar' => 'required|string',
            'title_en' => 'required|string',
            ]);

            $category = new Inspection();
            $category->setTranslation('title', 'ar', $request->title_ar);
            $category->setTranslation('title', 'en', $request->title_en);
            $category->specialty_id=$request->specialty_id;
            $category->save();

            return redirect()->back()->with('success', 'تم إضافة التخصص بنجاح');

        } catch (\Exception $e) {
            
            Log::error('Error storing category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage().'حدث خطأ أثناء إنشاء القسم. حاول مرة أخرى.');
        }
    }



    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try {
            $request->validate([
            'title_ar' => 'required|string',
            'title_en' => 'required|string',
            ]);

            $category = Inspection::findOrFail($id);

        

            $category->update([
               
                'title' => [
                    'ar' =>$request->title_ar,
                    'en' =>$request->title_en,
                ],
             
                'specialty_id'=>$request->specialty_id,

               
            ]);

            return redirect()->back()->with('success', 'تم تحديث التخصص بنجاح');
        } catch (\Exception $e) {
            Log::error('Error updating category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage() .'حدث خطأ أثناء تحديث التخصص. حاول مرة أخرى.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        try {
          
            $spiclity = Inspection::findOrFail($id);

         

            $spiclity->delete();

            return redirect()->back()->with('success', 'تم حذف الفحص بنجاح');
        } catch (\Exception $e) {
            Log::error('Error deleting category: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء حذف الفحص. حاول مرة أخرى.');
        }
    }
}