<?php

namespace App\Http\Controllers\Admin;

use Storage;
use App\Models\Brand;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class MediaController  extends Controller
{
  
 public function upload(Request $request)
{
    $request->validate([
        'images.*' => 'required|image|max:2048',
    ]);

    $urls = [];

    if ($request->hasFile('images')) {
        foreach ($request->file('images') as $image) {
            $filename = time() . '_' . uniqid() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('storage/product_images'), $filename);
            $urls[] = asset('storage/product_images/' . $filename); // ✅ صح هنا
        }
    } else {
        Log::warning("No images found in request.");
    }

    return response()->json(['urls' => $urls]);
}
  
    public function index() 
    {
        $folder = public_path('storage/product_images');
        $files  = [];

        if (is_dir($folder)) {
          
            foreach (scandir($folder) as $file) {   
                if (!in_array($file, ['.', '..'])) {
                 
                    $files[] = 'product_images/' . $file;
                }
            }
        }

       

        return view('admin.pages.media_library.media', compact('files'));
    }
}