<?php

namespace App\Http\Controllers\Admin;

use App\Models\Notification;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class NotificationController extends Controller
{
    /**
     * Display a listing of the notifications.
     */
    public function index()
    {
        $notifications = auth()->user()->notifications()->latest()->paginate(10);
        return view('admin.pages.notifications.index', compact('notifications'));
    }

    /**
     * Mark a single notification as read.
     */
    public function markAsRead(Request $request, $id)
    {
        try {
            $notification = auth()->user()->notifications()->findOrFail($id);
            $notification->update(['is_read' => true]);

            return response()->json(['success' => true, 'message' => 'تم تحديد الإشعار كمقروء']);
        } catch (\Exception $e) {
            Log::error('Error marking notification as read: ' . $e->getMessage());
            return response()->json(['success' => false, 'message' => 'حدث خطأ. حاول مرة أخرى.'], 500);
        }
    }

    /**
     * Mark all notifications as read.
     */
    public function markAllAsRead(Request $request)
    {
        try {
            auth()->user()->notifications()->where('is_read', 0)->update(['is_read' => true]);
            return redirect()->route('admin.notifications.index')->with('success', 'تم تحديد جميع الإشعارات كمقروءة');
        } catch (\Exception $e) {
            Log::error('Error marking all notifications as read: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء تحديد الإشعارات كمقروءة');
        }
    }
}