<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Models\Store;
use App\Models\SparePart;
use App\Traits\ProductTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\Vendor;
use App\Models\CarModel;
use App\Models\Brand;

class OfferController extends Controller
{
    use ProductTrait;
    public function index()
    {
        $offers = SparePart::whereNotNull('discount_percent')->get();


        return view('admin.pages.offer.index', compact('offers'));
    }

    // Show the form for creating a new resource
    public function create()
    {
        $categories = Category::all();
        $vendores=Vendor::all();
        $brands=Brand::all();
        return view('admin.pages.offer.add', compact('categories', 'vendores','brands'));
    }

    public function store(Request $request)
    {

         try {
          

            //   $this->validateProduct($request);
            $product = SparePart::create([
                'name' => $request->name_ar,
                'description' =>$request->details_ar,
                'price' => $request->price,
                'category_id' => $request->category_id,
                'brand_id' => $request->brand_id,
              //  'model_id' => $request->model_id,
                'vendor_id' => $request->vendor_id,
                'origin_country' => $request->origin_country,
                'warranty_period' => $request->warranty_period,
                'stock' => $request->quantity ?? 1,
                'is_active'=>$request->is_active,
                 'offer_starts_at'=>$request->offer_starts_at,
                'offer_ends_at'=>$request->offer_ends_at,
                'discount_percent'=>$request->discount_percent,
            ]);

                          $product->models()->sync($request->model_ids);

            $galleryImages = [];
            if ($request->hasFile('images')) {
                foreach ($request->file('images') as $image) {
                  
                     $fileName = time() . '.' . $image->getClientOriginalExtension();
                     $image->move(public_path('storage/products/gallery'), $fileName);
                
                    $imagePath = 'products/gallery/' . $fileName; 
                    $product->images()->create([
                        'path' => $imagePath,
                    ]);
                }
            }
            return redirect()->route('admin.offers.index')->with('success', 'offer created successfully');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }

    }

    // public function show(Product $product)
    // {
    //     return view('products.show', compact('product'));
    // }

    public function edit($id)
    {
         $product = SparePart::findOrFail($id);
         $categories = Category::all();
         $brands = Brand::all();

       
        return view('admin.pages.offer.edit', compact('product', 'categories','brands'));
    }


    public function update(Request $request, $id)
    {
    
        $product = SparePart::findOrFail($id);

          $product = $product->update([
                'name' => $request->name_ar,
                'description' =>$request->description,
                'price' => $request->price,
                'category_id' => $request->category_id,
                'brand_id' => $request->brand_id,
                'model_id' => $request->model_id,
                'origin_country' => $request->origin_country,
                'warranty_period' => $request->warranty_period,
                'stock' => $request->stock ,
               
                 'offer_starts_at'=>$request->start_time,
                'offer_ends_at'=>$request->end_time,
                'discount_percent'=>$request->discount_percent,
            ]);
            $galleryImages = [];
            if ($request->hasFile('images')) {
                foreach ($request->file('images') as $image) {
                  
                     $fileName = time() . '.' . $image->getClientOriginalExtension();
                     $image->move(public_path('storage/products/gallery'), $fileName);
                
                    $imagePath = 'products/gallery/' . $fileName; 
                    $product->images()->create([
                        'path' => $imagePath,
                    ]);
                }
            }

       
        return redirect()->back()->with('success', 'تم تحديث المنتج بنجاح.');
    }

    public function destroy(SparePart $product)
    {
        $product->delete();
        return redirect()->route('admin.products.index')->with('success', 'Product deleted successfully');
    }
    public function updateStatus(Request $request, $id)
    {
        $request->validate([
            'status' => 'required|integer|in:0,1',
        ]);
        $statusMap = [
            1 => 'معلق',
            2 => 'تمت الموافقه',
            3 => 'تم الرفض',
        ];

        $product = SparePart::findOrFail($id);
        $product->is_active = $request->status;
        $product->save();

        return redirect()->back()->with('success', 'تم تحديث الحالة بنجاح');
    }


}