<?php

namespace App\Http\Controllers\Admin;

use App\Models\Order;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\UserNotificationService;

class OrderController extends Controller
{
    public function index()
    {
        $orders = Order::all();
        return view('admin.pages.order.index', compact('orders'));
    }

    public function create()
    {
        return view('orders.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'ClientID' => 'required|string|max:255',
            'payment_method' => 'required|string|max:255',
            'TotalAmount' => 'required|numeric',
            'Status' => 'required|string|max:255',
        ]);

        Order::create($validated);

        return redirect()->route('orders.index')->with('success', 'Order created successfully');
    }

    public function show($id)
    {
        $order = Order::findOrFail($id);
        return view('admin.pages.order.show', compact('order'));
    }

    public function edit($id)
    {
        $order = Order::findOrFail($id);
        return view('orders.edit', compact('order'));
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
           
            'status' => 'required|string|max:255',
        ]);

        $order = Order::findOrFail($id);

        
        $order->update($validated);
         $userNotifier = new UserNotificationService();

            $userNotifier->orderChangeStatus(
                $order->user->id,
                $order->id,
                $request->status
             );

        return redirect()->route('admin.orders.index')->with('success', 'تم تحديث حالة الطلب بنجاح');
    }

    // Remove the specified order from the database
    public function destroy($id)
    {
        $order = Order::findOrFail($id);
        $order->delete();

        return redirect()->route('admin.orders.index')->with('success', 'تم حذف الطلب بنجاح');
    }
}