<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Governorate;

use App\Models\Package;
use App\Models\PackageCategory;

use Illuminate\Http\Request;

class PackageCategoryController extends Controller
{
    // ✅ List all governorates
    public function index()
    {
        $categories = PackageCategory::all();
        return view('admin.pages.packages-category.index', compact('categories'));
    }

    // ✅ Show form to create new governorate (optional if using modal)
    public function create()
    {
        return view('admin.pages.governate.create');
    }

    // ✅ Store new governorate
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string|max:255',

        ]);

      $package=  PackageCategory::create([
            'name' => 
                 $request->name,
                 'description'=>$request->description
           
        ]);



        return redirect()->back()->with('success', 'تمت إضافة الفئة بنجاح');
    }

    // ✅ Show form to edit
    public function edit(Governorate $governorate)
    {
        return view('admin.pages.governate.edit', compact('governorate'));
    }

    // ✅ Update governorate
    public function update(Request $request, Package $governorate)
    {
       
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string|max:255',
           
        ]);

        

        $governorate->update([
            'name' => 
                 $request->name,
                 'description'=>$request->description
           
          
        ]);

        return redirect()->back()->with('success', 'تم تعديل الباقة بنجاح');
    }

    // ✅ Delete governorate
    public function delete(PackageCategory $governorate)
    {
        $governorate->delete();
        return redirect()->back()->with('success', 'تم حذف الفئة بنجاح');
    }
}
