<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Governorate;

use App\Models\Package;
use App\Models\Brand;
use App\Models\SparePart;

use Illuminate\Http\Request;

class PackageController extends Controller
{
    // ✅ List all governorates
    public function index()
    {
        $packages = Package::whereNull('parent_id')->get();
        $brands=Brand::all();
        return view('admin.pages.packages.index', compact('packages','brands'));
    }

    // ✅ Show form to create new governorate (optional if using modal)
    public function create()
    {
        return view('admin.pages.governate.create');
    }

    // ✅ Store new governorate
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string|max:255',
                   'car_models.*' => 'exists:models,id',

        ]);

      $package=  Package::create([
            'name' => 
                 $request->name,
                 'description'=>$request->description
           
        ]);

            $package->carModels()->attach($request->car_models);
           if ($request->product_ids) {
        $package->relatedProducts()->sync($request->product_ids);
    }

        return redirect()->back()->with('success', 'تمت إضافة الباقة بنجاح');
    }

    // ✅ Show form to edit
    public function edit(Governorate $governorate)
    {
        return view('admin.pages.governate.edit', compact('governorate'));
    }

    // ✅ Update governorate
    public function update(Request $request, Package $governorate)
    {
       
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string|max:255',
           
        ]);

        

        $governorate->update([
            'name' => 
                 $request->name,
                 'description'=>$request->description
           
          
        ]);

        return redirect()->back()->with('success', 'تم تعديل الباقة بنجاح');
    }

    // ✅ Delete governorate
    public function delete( $id)
    {    $package=Package::find($id);
            $package->delete();
        return redirect()->back()->with('success', 'تم حذف الفئة بنجاح');
    }


public function getSubPackages($parentId)
{
    return Package::where('parent_id', $parentId)
        ->select('id', 'name')
        ->get();
}

public function getProductsByModels(Request $request)
{
    $products = SparePart::whereHas('models', function ($q) use ($request) {
        $q->whereIn('models.id', $request->model_ids);
    })
    ->select('id', 'name')
    ->get();

    return response()->json($products);
}


}
