<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\OrderItem;
use App\Models\Category;
use App\Models\SparePartOffer;
use App\Models\SparePart;
use App\Models\OrderPayment;
use App\Models\SparePartOfferPayment;
use App\Models\CustomPartRequestItem;
use App\Traits\ProductTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Exports\SparePartTemplateExport;
use Maatwebsite\Excel\Facades\Excel;

class PaymentsController extends Controller
{
    use ProductTrait;
  
    public function customeRequest()
    {
        $customerequests = CustomPartRequestItem::with(['acceptedOffer.vendor', 'customPartRequest.user'])
        ->whereHas('acceptedOffer')
        ->orderBy('id', 'desc')
        ->get();
        return view('admin.pages.payments.custome_part_request', compact('customerequests'));
    }

   public function addMount(Request $request, $offerId)
    {
        $request->validate([
            'amount' => 'required|numeric|min:0.01',
        ]);

        $offer = SparePartOffer::findOrFail($offerId);

        if ($offer->status !== 'accepted') {
            return back()->withErrors('لا يمكن الدفع إلا للعروض المقبولة فقط');
        }

        SparePartOfferPayment::create([
            'spare_part_offer_id' => $offer->id,
            'amount' => $request->amount,
        ]);

        return back()->with('success', 'تمت إضافة الدفعة بنجاح');
    }


       public function orderItems()
    {
        $orderItems = OrderItem::with(['order.user', 'sparePart.vendor'])
        
        ->orderBy('id', 'desc')
        ->get();
        return view('admin.pages.payments.order_payments', compact('orderItems'));
    }

   public function addMountOrder(Request $request, $orderId)
    {
        $request->validate([
            'amount' => 'required|numeric|min:0.01',
        ]);

        $offer = OrderItem::findOrFail($orderId);

      

        OrderPayment::create([
            'order_id' => $offer->id,
            'amount' => $request->amount,
        ]);

        return back()->with('success', 'تمت إضافة الدفعة بنجاح');
    }




}