<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Models\Store;
use App\Models\SparePart;
use App\Models\Vendor;
use App\Models\Package;
use App\Models\PackageItem;

use App\Models\CarModel;
use App\Models\Brand;
use App\Models\PackageCategory;

use App\Traits\ProductTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Exports\SparePartTemplateExport;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\SparePartsImport;
use App\Models\SparePartFilter;

class ProductController extends Controller
{
    use ProductTrait;
    public function index()
    {
        $products = SparePart::whereNull('discount_percent')->get();
        $offers = SparePart::whereNotNull('discount_percent')->get();


        return view('admin.pages.product.index', compact('products','offers'));
    }

    // Show the form for creating a new resource
    public function create()
    {
        $categories = Category::all();
        $vendores=Vendor::all();
        $brands=Brand::all();
        $categories_Package=PackageCategory::all();

        $packages=Package::whereNull('parent_id')->get();
        return view('admin.pages.product.add', compact('categories_Package','categories','vendores','brands','packages'));
    }

    public function store(Request $request)
    { 
     
        try {
            $mainImage = null;
            if ($request->hasFile('image')) {
                $mainImage = $request->file('image')->store('products', 'public');
            }

            //   $this->validateProduct($request);
            $product = SparePart::create([
                'name' => [
                    'ar' => $request->name_ar,
                    'en' => $request->name_en ??  $request->name_ar,
                ],
                'description' =>$request->details_ar,
                'price' => $request->price,
                'category_id' => $request->category_id,
                'brand_id' => $request->brand_id,
             //   'model_id' => $request->model_id,
                'vendor_id' => $request->vendor_id,
                'origin_country' => $request->origin_country,
                'warranty_period' => $request->warranty_period,
                'stock' => $request->quantity ?? 1,
                'is_active'=>$request->is_active,
            ]);


              $product->models()->sync($request->model_ids);
            $galleryImages = [];
            if ($request->hasFile('images')) {
                foreach ($request->file('images') as $image) {
                  
                     $fileName = time() . '.' . $image->getClientOriginalExtension();
                     $image->move(public_path('storage/products/gallery'), $fileName);
                
                    $imagePath = 'products/gallery/' . $fileName; 
                    $product->images()->create([
                        'path' => $imagePath,
                    ]);
                }
            }
           if ($request->has('filters')) {
                foreach ($request->filters as $filterData) {
                SparePartFilter::create([
                    'spare_part_id'      => $product->id,
                    'category_filter_id' => $filterData['id'],
                    'value'              => $filterData['value'],
                ]);
              }
            }



            if ($request->has('packages')) {

                foreach ($request->packages as $pkg) {

                    PackageItem::create([
                        'package_id'          => $pkg['sub_package_id'], // 👈 sub package
                        'package_category_id' => $pkg['category_id'],
                        'spare_part_id'       => $product->id,
                    //    'price'               => $pkg['price'] ?? 0,
                        'is_main'             => $pkg['is_main'] ?? 0,
                        'is_installation'     => $pkg['is_installation'] ?? 0,
                    ]);
                }
            }


            return redirect()->route('admin.products.index')->with('success', 'Product created successfully');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }

    }

    // public function show(Product $product)
    // {
    //     return view('products.show', compact('product'));
    // }

    public function edit(SparePart $product)
    {
        $categories = Category::all();
        $brands = Brand::all();
        $selectedModelIds = $product->models()->pluck('models.id')->toArray();

        
        return view('admin.pages.product.edit', compact('product', 'categories','brands','selectedModelIds'));
    }


   public function update(Request $request, SparePart $product)
{
    $request->validate([
        'name_ar' => 'required|string|max:255',
        'name_en' => 'required|string|max:255',
        'price' => 'required|numeric|min:0',
        'stock' => 'required|integer|min:0',
        'category_id' => 'required|exists:categories,id',
        'brand_id' => 'required|exists:brands,id',
        'model_id' => 'required|exists:models,id',
        'origin_country' => 'required|string|max:255',
        'warranty_period' => 'required|string|max:255',
        'is_active' => 'required|boolean',
        'description' => 'nullable|string',
        'images.*' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:2048',
    ]);

    \DB::beginTransaction();

    try {
        // تحديث بيانات المنتج
        $product->setTranslations('name', [
            'ar' => $request->name_ar,
            'en' => $request->name_en,
        ]);

        $product->price = $request->price;
        $product->stock = $request->stock;
        $product->category_id = $request->category_id;
        $product->brand_id = $request->brand_id;
        $product->model_id = $request->model_id;
        $product->origin_country = $request->origin_country;
        $product->warranty_period = $request->warranty_period;
        $product->is_active = $request->is_active;
        $product->description = $request->description;
        $product->save();

        // إضافة الصور الجديدة إن وجدت
        if ($request->hasFile('images')) {
                foreach ($request->file('images') as $image) {
                
                    $fileName = time() . '.' . $image->getClientOriginalExtension();
                    $image->move(public_path('storage/products/gallery'), $fileName);
                
                    $imagePath = 'products/gallery/' . $fileName; 
                    $product->images()->create([
                        'path' => $imagePath,
                    ]);
                }
        }

        \DB::commit();

        return redirect()->route('admin.products.index')->with('success', 'تم تحديث المنتج بنجاح.');
    } catch (\Exception $e) {
        \DB::rollBack();
        return redirect()->back()->with('error', 'حدث خطأ أثناء تحديث المنتج: ' . $e->getMessage());
    }
}

    public function destroy( $id)
    {
        $sparepart=SparePart::find($id);
         $sparepart->delete();
        return redirect()->route('admin.products.index')->with('success', 'تم حذف المنتج بنجاح');
    }
    public function updateStatus(Request $request, $id)
    {
        $request->validate([
            'status_id' => 'required|integer|in:1,2,3',
        ]);
        $statusMap = [
            1 => 'معلق',
            2 => 'تمت الموافقه',
            3 => 'تم الرفض',
        ];

        $product = Product::findOrFail($id);
        $product->status_active_id = $request->status_id;
        $product->save();

        return redirect()->route('admin.products.index')->with('success', 'تم تحديث الحالة بنجاح');
    }

   /*  public function getModelsByBrand($brand_id)
    {
        $models = CarModel::where('brand_id', $brand_id)->get();
        return response()->json($models);
    } */
  public function getModelsByBrands(Request $request)
    {
        $request->validate([
            'brand_ids' => 'required|array',
            'brand_ids.*' => 'exists:brands,id',
        ]);

        $models = CarModel::whereIn('brand_id', $request->brand_ids)
            ->where('active', 1)
            ->get(['id', 'name']);
      
        return response()->json($models);
    }




    public function downloadSparePartsTemplate()
{
    return Excel::download(new SparePartTemplateExport, 'spare_parts_template.xlsx');
}




public function importSpareParts(Request $request)
{
    $request->validate([
        'import_file' => 'required|mimes:xlsx,xls,csv',
    ]);

    try {
        Excel::import(new SparePartsImport, $request->file('import_file'));
        return back()->with('success', 'تم استيراد قطع الغيار بنجاح');
    } catch (\Exception $e) {
        return back()->with('error', 'حدث خطأ أثناء الاستيراد: ' . $e->getMessage());
    }
}


}