<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
      $setting = Setting::pluck('value', 'key');
      
        return view('admin.pages.setting.website', compact('setting'));
    }
    public function update(Request $request)
    {
       
           
            $data = $request->validate([
            'facebook'       => 'nullable|max:255',
            'instagram'      => 'nullable|max:255',
            'youtube'        => 'nullable|max:255',
            'tiktok'         => 'nullable|max:255',
            'email'          => 'nullable|max:255',
            'phone'          => 'nullable|string|max:255',
            'whatsapp'       => 'nullable|string|max:255',
            'address'        => 'nullable|string|max:255',
            'user_android'   => 'nullable|max:255',
            'vendor_android' => 'nullable|max:255',
            'user_ios'       => 'nullable|max:255',
            'vendor_ios'     => 'nullable|max:255',
          //  'logo'           => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
       
    

        // 2. List of all keys except the file
        $keys = [
            'facebook', 'instagram', 'youtube', 'tiktok',
            'email', 'phone', 'whatsapp', 'address',
            'user_android', 'vendor_android',
            'user_ios', 'vendor_ios',
        ];

        // 3. Loop and updateOrCreate each setting
        foreach ($keys as $key) {
            Setting::updateOrCreate(
                ['key'   => $key],
                ['value' => $data[$key] ?? null]
            );
        }

        // 4. Handle logo upload if present
        if ($request->hasFile('logo')) {
            $path = $request->file('logo')->store('logos', 'public');
            Setting::updateOrCreate(
                ['key'   => 'logo'],
                ['value' => basename($path)]
            );
        }

        return redirect()->back()->with('success', 'تم تحديث الإعدادات بنجاح'); 
    }

    public function updateVendorVisibility(Request $request)
    {
        Setting::updateOrCreate(
            ['key' => 'show_vendor'],
            ['value' => $request->boolean('show_vendor') ? 1 : 0]
        );

        return back()->with('success', 'تم تحديث حالة ظهور البائع بنجاح');
    }
}