<?php

namespace App\Http\Controllers\Admin;

use Storage;
use App\Models\Specialty;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class SpclizationController extends Controller
{
   
    public function index()
    {
        $spiclizations = Specialty::with('inceptions')->get();
        return view('admin.pages.suppliers_spiclizations.index', compact('spiclizations'));
    }

   

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
     
        try {
             $request->validate([
            'title_ar' => 'required|string',
            'title_en' => 'required|string',
            ]);

            $category = new Specialty();
            $category->setTranslation('title', 'ar', $request->title_ar);
            $category->setTranslation('title', 'en', $request->title_en);
            $category->save();

            return redirect()->back()->with('success', 'تم إضافة التخصص بنجاح');

        } catch (\Exception $e) {
            
            Log::error('Error storing category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage().'حدث خطأ أثناء إنشاء القسم. حاول مرة أخرى.');
        }
    }



    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try {
            $request->validate([
            'title_ar' => 'required|string',
            'title_en' => 'required|string',
            ]);

            $category = Specialty::findOrFail($id);

        

            $category->update([
                'title' => [
                    'ar' =>$request->title_ar,
                    'en' =>$request->title_en,
                ],
               
            ]);

            return redirect()->route('admin.spiclizations.index')->with('success', 'تم تحديث التخصص بنجاح');
        } catch (\Exception $e) {
            Log::error('Error updating category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage() .'حدث خطأ أثناء تحديث التخصص. حاول مرة أخرى.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        try {
          
            $spiclity = Specialty::findOrFail($id);

         

            $spiclity->delete();

            return redirect()->route('admin.spiclizations.index')->with('success', 'تم حذف التخصص بنجاح');
        } catch (\Exception $e) {
            Log::error('Error deleting category: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء حذف التخصص. حاول مرة أخرى.');
        }
    }
}