<?php

namespace App\Http\Controllers\Admin;

use App\Models\Advantage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;


class StaticPageController extends Controller
{
    public function index()
    {
        $advantages = Advantage::all()->groupBy('type');
        return view('admin.pages.site_statistics.index', compact('advantages'));
    }



    public function update(Request $request, $id)
    {
        // Validate the incoming data
        $request->validate([
            // 'name_page' => 'required|string|max:255',
            'value' => 'required|array',
            'value.en' => 'required|string',
            'value.ar' => 'required|string',
        ]);

        // Find the record by its ID
        $statistic = StaticPage::findOrFail($id);

        // $statistic->name_page = $request->name_page;
        $statistic->value = json_encode($request->value); // Encoding 'value' to JSON format

        $statistic->save();

        // Redirect back with a success message
        return redirect()->route('admin.static_pages.index')->with('success', 'تم تحديث الصفحة بنجاح!');
    }


    // public function destroy(StaticPage $staticPage)
    // {
    //     $staticPage->delete();
    //     return redirect()->route('static_pages.index')->with('success', 'Page deleted successfully');
    // }
}