<?php

namespace App\Http\Controllers\Admin;

use Storage;
use App\Models\CarStyle;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;

class StyleController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $styles = CarStyle::all();
        return view('admin.pages.car_style.index', compact('styles'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.pages.car_style.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
               
            ]);

           

            $category = CarStyle::create([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
              
            ]);

            return redirect()->route('admin.carstyle.index')->with('success', 'تم إنشاء الطراز بنجاح');
        } catch (\Exception $e) {
            Log::error('Error storing category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', $e->getMessage().'حدث خطأ أثناء إنشاء الطراز. حاول مرة أخرى.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $CarStyles = CarStyle::findOrFail($id);
        return view('admin.pages.category.show', compact('CarStyles'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $CarStyle = CarStyle::findOrFail($id);
        return view('admin.pages.car_CarStyle.edit', compact('category', 'CarStyle'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        try {
            $validated = $request->validate([
                'name_ar' => 'required|string|max:255',
                'name_en' => 'required|string|max:255',
              
            ]);

            $category = CarStyle::findOrFail($id);

           

            $category->update([
                'name' => [
                    'ar' => $validated['name_ar'],
                    'en' => $validated['name_en'],
                ],
               
            ]);

            return redirect()->route('admin.carstyle.index')->with('success', 'تم تحديث الطراز بنجاح');
        } catch (\Exception $e) {
            Log::error('Error updating category: ' . $e->getMessage(), ['request' => $request->all()]);
            return redirect()->back()->with('error', 'حدث خطأ أثناء تحديث الطراز. حاول مرة أخرى.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        try {
            $category = CarStyle::findOrFail($id);

           

            $category->delete();

            return redirect()->route('admin.carstyle.index')->with('success', 'تم حذف الطراز بنجاح');
        } catch (\Exception $e) {
            Log::error('Error deleting category: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء حذف الطراز. حاول مرة أخرى.');
        }
    }
}