<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Governorate;

use App\Models\Package;
use App\Models\CarModel;
use App\Models\ProductService;
use App\Models\SparePart;
use App\Models\PackageItem;

use App\Models\PackageCategory;

use Illuminate\Http\Request;

class SubPackagesController extends Controller
{
    public function index()
    {
        $packages = Package::whereNotNull('parent_id')->get();
        $mainPackages=Package::whereNull('parent_id')->get();
        return view('admin.pages.sub_backages.index', compact('packages'));
    }

    public function create()
    {
        $parentPackages = Package::whereNull('parent_id')->get();
    $categories = PackageCategory::where('is_active', true)->get();
    $spareParts = SparePart::all();
    $services   = ProductService::all();
        return view('admin.pages.sub_backages.add', compact(
        'parentPackages',
        'categories',
        'spareParts',
        'services'
    ));
    }

 public function store(Request $request)
{   
    $request->validate([
        'name' => 'required|string|max:255',
        'description' => 'nullable|string',
        'parent_id' => 'nullable|exists:packages,id',
        'categories' => 'nullable|array',
    ]);

    try {
        \DB::beginTransaction(); // بداية الترانزاكشن

        // إنشاء الحزمة
        $package = Package::create([
            'name' => $request->name,
            'description' => $request->description,
            'parent_id' => $request->parent_id,
        ]);

        // حفظ العناصر إذا موجودة
        if ($request->categories) {
            foreach ($request->categories as $catIndex => $catData) {
                $categoryId = $catData['package_category_id'] ?? null;
                if (!$categoryId) continue;

                if (isset($catData['items']) && is_array($catData['items'])) {
                    foreach ($catData['items'] as $item) {

                        /* $sparePartId = null;
                        if (!empty($item['spare_part_id'])) {
                            $sparePart = SparePart::where('name->ar', $item['spare_part_id'])->first();
                            dd($sparePart);
                            if ($sparePart) {
                                $sparePartId = $sparePart->id;
                            }
                        } */

                        PackageItem::create([
                            'package_id' => $package->id,
                            'package_category_id' => $categoryId,
                            'spare_part_id' =>  $item['spare_part_id'] ,
                          //  'price' => $item['price'] ?? 0,
                            'is_main' => isset($item['is_main']) ? true : false,
                            'is_installation' => isset($item['is_installation']) ? true : false,
                            'name' => $item['spare_part_id'] ?? null,
                        ]);
                    }
                }
            }
        }

        \DB::commit(); // حفظ الترانزاكشن

        return redirect()->route('admin.SubPackages.index')->with('success', 'تم حفظ الحزمة بنجاح!');

    } catch (\Exception $e) {
        \DB::rollBack(); // التراجع لو حصل خطأ

        // يمكنك تسجيل الخطأ في اللوج
        \Log::error('Package Store Error: '.$e->getMessage());

        return redirect()->back()->withInput()->with('error', 'حدث خطأ أثناء حفظ الحزمة: ' . $e->getMessage());
    }
}



    // ✅ Show form to edit
    public function edit($id)
    {
$package = Package::with(['items.category', 'items.product'])->findOrFail($id);

// ترتيب العناصر حسب category_id
$categoriesWithItems = $package->items->groupBy('package_category_id');
          $parentPackages = Package::whereNull('parent_id')->get();
    $categories = PackageCategory::where('is_active', true)->get();
    $spareParts = SparePart::all();
    $services   = ProductService::all();
        return view('admin.pages.sub_backages.edit', compact('package','parentPackages','categoriesWithItems',
        'categories',
        'spareParts',
        'services'));
    }

    // ✅ Update governorate
   public function update(Request $request, Package $package)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'description' => 'nullable|string',
        'parent_id' => 'nullable|exists:packages,id',
        'categories' => 'nullable|array',
    ]);

    try {
        $package->update([
            'name' => $request->name,
            'description' => $request->description,
            'parent_id' => $request->parent_id,
        ]);

        // حذف العناصر القديمة
        PackageItem::where('package_id', $package->id)->delete();

        // إضافة العناصر الجديدة
        if ($request->categories) {
            foreach ($request->categories as $catIndex => $catData) {
                $categoryId = $catData['package_category_id'] ?? null;
                if (!$categoryId) continue;

                if (isset($catData['items']) && is_array($catData['items'])) {
                    foreach ($catData['items'] as $item) {
                        $sparePartId = null;
                        if (!empty($item['spare_part_id'])) {
                            $sparePart = SparePart::where('name->ar', $item['spare_part_id'])->first();
                            if ($sparePart) {
                                $sparePartId = $sparePart->id;
                            }
                        }

                        PackageItem::create([
                            'package_id' => $package->id,
                            'package_category_id' => $categoryId,
                            'spare_part_id' => $sparePartId,
                            'price' => $item['price'] ?? 0,
                            'is_main' => isset($item['is_main']),
                            'is_installation' => isset($item['is_installation']),
                            'name' => $item['spare_part_id'] ?? null,
                        ]);
                    }
                }
            }
        }

        return redirect()->route('admin.SubPackages.index')->with('success', 'تم تحديث الحزمة بنجاح!');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'حدث خطأ: ' . $e->getMessage());
    }
}


    // ✅ Delete governorate
    public function destroy(Governorate $governorate)
    {
        $governorate->delete();
        return redirect()->back()->with('success', 'تم حذف المحافظة بنجاح');
    }
}
