<?php

namespace App\Http\Controllers\Admin;

use App\Models\Subscription;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SubscribersController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $subscribes = Subscription::all();
        return view('admin.pages.subscribes.index', compact('subscribes'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function notify(Request $request, $id)
    {
        $subscribe = Subscription::findOrFail($id);
        // Logic to send notification (e.g., email, SMS, etc.)
        // Example: Notification::send($subscribe, new CustomNotification($request->message));
    
        return redirect()->back()->with('success', 'تم ارسال الاشعار بنجاح.');
    }
    

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $subscriber = Subscription::findOrFail($id);
        $subscriber->delete();

        return redirect()->route('admin.subscribe')->with('success', 'Subscriber deleted successfully');
    }


}