<?php

namespace App\Http\Controllers\Admin;

use App\Models\City;
use App\Models\Governorate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\EmirateResource;

class TownController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
       
        $cities = City::all();
        $governorates=Governorate::all();
        return view('admin.pages.towm.index', compact('cities','governorates'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // Optional for API routes; for web-based forms, return a view
        return view('emirates.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
       
        // Validate the input
        $request->validate([
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
            'delivery_price' => 'required|numeric|min:0',
            'governorate_id'=>'required'
        ]);
       
      

        // Create a new Emirate
          City::create([
            'name' => [
                'ar' => $request->name_ar,
                'en' => $request->name_en,
            ],
            'delivery_price' => $request->delivery_price,
            'governorate_id' =>$request->governorate_id,
        ]);
        
        // Redirect with a success message
        return redirect()->back()->with('success', 'تم إضافة المدينة بنجاح');
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $emirate = City::findOrFail($id);
        return new EmirateResource($emirate);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $emirate = City::findOrFail($id);

        // Optional for API routes; for web-based forms, return a view
        return redirect()->back()->with('success', 'تم إضافة المدينة بنجاح');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
       
       
       // Validate the input data
        $request->validate([
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
            'delivery_price' => 'required|numeric|min:0',
        ]);

        $emirate = City::findOrFail($id);

        $emirate->update([
           'name' => [
                'ar' => $request->name_ar,
                'en' => $request->name_en,
            ],
            'delivery_price' => $request->delivery_price,
        ]); 


        $emirate->save();

        return redirect()->back()->with('success', 'تم تحديث البيانات بنجاح');
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $emirate = City::findOrFail($id);
        $emirate->delete();

        return redirect()->back()->with('success', 'تم حذف المدينة بنجاح');

    }
}