<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Winch;
use App\Notifications\WinchRequestNotification;
use Illuminate\Http\Request;

class WinchController extends Controller
{
    public function index()
    {
        $winches = Winch::latest()->get();
        return view('admin.pages.winsh.index', compact('winches'));
    }

    public function create()
    {
        $users = User::select('id', 'full_name')->get();
        return view('admin.pages.winsh.create', compact('users'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'user_id' => 'required|exists:users,id',
            'phone_number' => 'required|string',
            'car_description' => 'nullable|string',
            'current_address' => 'required|string',
            'destination_address' => 'required|string',
            'issue' => 'nullable|string',
            'status' => 'required|in:pending,in_progress,completed,cancelled',
        ]);

        $winch = Winch::create($request->only([
            'name', 'user_id', 'phone_number', 'car_description',
            'current_address', 'destination_address', 'issue', 'status'
        ]));

        // Send notification to user
        $user = $winch->user;
        if ($user) {
            $user->notify(new WinchRequestNotification($winch));
        }

        return redirect()->route('admin.winches.index')->with('success', 'تم إضافة طلب الونش بنجاح.');
    }

    public function edit(Winch $winch)
    {
        $users = User::select('id', 'full_name')->get();
        return view('admin.winches.edit', compact('winch', 'users'));
    }

    public function update(Request $request, Winch $winch)
    {
        $request->validate([
            'name' => 'required|string',
            'user_id' => 'required|exists:users,id',
            'phone_number' => 'required|string',
            'car_description' => 'nullable|string',
            'current_address' => 'required|string',
            'destination_address' => 'required|string',
            'issue' => 'nullable|string',
            'status' => 'required|in:pending,in_progress,completed,cancelled',
        ]);

        $winch->update($request->only([
            'name', 'user_id', 'phone_number', 'car_description',
            'current_address', 'destination_address', 'issue', 'status'
        ]));

        return redirect()->route('admin.winches.index')->with('success', 'تم تعديل طلب الونش بنجاح.');
    }

    public function destroy(Winch $winch)
    {
        $winch->delete();
        return redirect()->route('admin.winches.index')->with('success', 'تم حذف طلب الونش بنجاح.');
    }
    public function updateStatus(Request $request, Winch $winch)
    {
        $request->validate([
            'status' => 'required|in:pending,in_progress,completed,cancelled',
        ]);

        $winch->update([
            'status' => $request->status,
        ]);

        return redirect()->route('admin.winches.index')->with('success', 'تم تحديث حالة الطلب بنجاح.');
    }
}
