<?php

namespace App\Http\Controllers\Api\Website;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\BlogResource;
use App\Http\Resources\SiteDetailResource;
use App\Http\Resources\SettingResource;
use App\Http\Resources\ServicesResource;
use App\Models\Blog;
use App\Models\SiteDetail;
use App\Models\Setting;
use App\Models\Service;
class HomeController extends Controller
{
    public function index()
    {

        // $siteDetails = SiteDetail::with('image')->get();
        $section_download_app = SiteDetail::where('key', 'section_download_app')->with('images')->latest()->first();
        $second_section = SiteDetail::where('key', 'second_section')->with('images')->get();
        $terms_condition = SiteDetail::where('key', 'terms_condition')->with('images')->get();
        $second_section_step = SiteDetail::where('key', 'second_section_step')->with('images')->get();

        $header_section = SiteDetail::where('key', 'header_section')->with('images')->latest()->first();
        $third_section = SiteDetail::where('key', 'third_section')->with('images')->latest()->first();
       // $setting=Setting::all();
        $settings = Setting::all()->pluck('value', 'key');
        $services=Service::all();
        return response()->json([
            'message' => 'data retrieved successfully',
            'site_header' => $header_section ? new SiteDetailResource($header_section) : null,
            'second_section' => SiteDetailResource::collection($second_section),
            'section_download_app' => $section_download_app ? new SiteDetailResource($section_download_app) : null,
            'third_section' => $third_section ? new SiteDetailResource($third_section) : null,
            'terms_condition' => $terms_condition ? SiteDetailResource::collection($terms_condition) : null,
            'second_section_step' => $second_section_step ? SiteDetailResource::collection($second_section_step) : null,
            'setting'=>$settings ? $settings : null,
            'services'=>$services ? ServicesResource::collection($services): null,
        ]);
    }

}