<?php
namespace App\Http\Controllers\MobileApp;

use Exception;
use Carbon\Carbon;
use App\Models\City;
use App\Models\User;
use App\Models\ContactUs;
use App\Mail\PasswordReset;
use App\Models\Governorate;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Resources\InspectionResource;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\GovernorateResource;
use App\Http\Resources\ContactUsIconResource;
use Illuminate\Validation\ValidationException;
use App\Models\VendorTimetable;
use App\Models\Appointment;
use App\Models\Vendor;
use App\Models\VendorInspection;
use App\Services\VendorNotificationService;
use App\Http\Resources\AppointmentResource;


class AppointmentController extends Controller
{
      public function __construct(Request $request)
    {
        $locale = $request->header('Accept-Language', 'en');
        \Illuminate\Support\Facades\App::setLocale($locale);
    }

public function getAvailableSlots(Request $request)
{
    $vendorId = $request->vendor_id;
    $date = $request->date;

    $dayOfWeek = strtolower(Carbon::parse($date)->format('l')); // e.g. 'monday'

    $timetable = VendorTimetable::where('vendor_id', $vendorId)
        ->where('day_of_week', $dayOfWeek)
        ->where('is_available', true)
        ->first();

    if (!$timetable) {
        return response()->json(['slots' => []]);
    }

    $start = Carbon::parse($timetable->start_time);
    $end = Carbon::parse($timetable->end_time);

    $totalMinutes = $start->diffInMinutes($end);
    $slotDuration = floor($totalMinutes / 3); // 3 فترات متساوية

    $slots = [];
    for ($i = 0; $i < 3; $i++) {
        $slotStart = $start->copy()->addMinutes($i * $slotDuration);
        $slotEnd = $slotStart->copy()->addMinutes($slotDuration);

        $slots[] = [
            'start_time' => $slotStart->format('H:i'),
            'end_time' => $slotEnd->format('H:i')
        ];
    }

    return response()->json(['slots' => $slots]);
}
public function reserveAppointment(Request $request)
{
    $request->validate([
        'vendor_id' => 'required|exists:vendors,id',
        'inspection_id' => 'required|exists:inspections,id',
        'date' => 'required|date',
        'start_time' => 'required|date_format:H:i',
        'end_time'=>'required|date_format:H:i',
    ]);
  
    $startTime = Carbon::createFromFormat('H:i', $request->start_time);
     $endTime = Carbon::createFromFormat('H:i', $request->end_time);

   /*  $inspection = VendorInspection::findOrFail($request->inspection_id);
    $startTime = Carbon::createFromFormat('H:i', $request->start_time);
    $endTime = $startTime->copy()->addMinutes($inspection->duration); */

    
   /*  $isBooked = Appointment::where('vendor_id', $request->vendor_id)
        ->where('date', $request->date)
        ->where(function ($q) use ($startTime, $endTime) {
            $q->whereBetween('start_time', [$startTime->format('H:i'), $endTime->format('H:i')])
              ->orWhereBetween('end_time', [$startTime->format('H:i'), $endTime->format('H:i')]);
        })->exists();

    if ($isBooked) {
        return response()->json(['status' => false, 'message' => 'This time slot is already booked']);
    } */

    $appointment = Appointment::create([
        'vendor_id' => $request->vendor_id,
        'user_id' => auth()->id(), // or pass in the user
        'inspection_id' => $request->inspection_id,
        'date' => $request->date,
        'start_time' =>$startTime->format('H:i'),
        'end_time' => $endTime->format('H:i'),
    ]);


    $vendorNotifier = new VendorNotificationService();

    $vendorNotifier->appointmentNotification(
                $appointment->id,
                $request->vendor_id,
             );
    return response()->json(['status' => true, 'message' => 'Appointment booked successfully', 'data' => $appointment]);
}
public function vendorInceptions($id)
{
   
   $vendor = Vendor::find( $id);
   // dd($vendor->inspections);
    return response()->json([
        'status' => true,
        'message' => 'Vendor inspections retrieved successfully.',
        'data' => InspectionResource::collection($vendor->inspections),
    ]);
}
public function userAppointments()
{
   $appointments = Appointment::where('user_id', auth()->id())->get();
   return response()->json(['status' => true, 'message' => 'your Appointments retrived successfully', 'data' => AppointmentResource::collection($appointments)]);

}
public function delete($id){
    
    $appointment=Appointment::find($id);
    
    $appointment->delete();
    
    
    return response()->json([
        'status' => true,
        'message' => trans('messages.appointment deleted successfully'),
    ]);

}

}