<?php
namespace App\Http\Controllers\MobileApp;
use App\Http\Controllers\Controller;

use App\Models\CustomPartRequest;
use App\Traits\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\CustomPartRequestResource;
use App\Models\SparePartOffer;
use App\Http\Resources\OrderResource;
use App\Http\Resources\FillterResource;
use App\Models\CartItem;
use App\Models\SparePart;
use App\Http\Resources\SparePartResource;
use App\Http\Resources\SparePartOfferResource;
use App\Models\Category;

class CategoryProductController extends Controller
{
    use ApiTrait;
       public function __construct(Request $request)
    {
        $locale = $request->header('Accept-Language', 'en');
        \Illuminate\Support\Facades\App::setLocale($locale);
    }
 
    public function index($id,Request $request)
    {
   
    $user = Auth::guard('sanctum')->user();
          
          $query = SparePart::where('category_id', $id)
                ->where('stock', '>', 0)
                ->where('is_active', 1);
            /*     ->when($request->has('search'), function ($query) use ($request) {
                    $search = $request->search;
                    $query->where(function ($q) use ($search) {
                        $q->where('name->ar', 'like', "%$search%")
                        ->orWhere('name->en', 'like', "%$search%");
                    });
                }); */
                

            if ($user) {
                $userCarModelIds = $user->userCars()->pluck('model_id');

             if ($userCarModelIds->isNotEmpty()) {
                    // Use whereExists for better performance than whereHas
                    $query->whereExists(function ($q) use ($userCarModelIds) {
                        $q->selectRaw(1)
                        ->from('sparepart_model')
                        ->whereColumn('sparepart_model.spare_part_id', 'spare_parts.id')
                        ->whereIn('sparepart_model.car_model_id', $userCarModelIds);
                    });
                } else {
                        
                    return $this->apiResponse(true, 'No spare parts found for your cars', [], []);
                }
            }
           
           if ($request->has('filters') && is_array($request->filters)) {
                foreach ($request->filters as $key => $value) {
                    $query->whereHas('filters', function ($q) use ($key, $value) {
                        $q->whereHas('categoryFilter', function ($subQ) use ($key, $value) {
                            $subQ->where("key->" . app()->getLocale(), $key)
                                ->where('value', $value);
                        });
                    });
                }
            }

            $spareParts = $query->with([ 'vendor', 'category', 'images'])->get();
            
            return $this->apiResponse(
                true,
                'Category products retrieved successfully',
                [],
               ["data"=> SparePartResource::collection($spareParts),"filters"=>FillterResource::collection(Category::find($id)->filters)]
            );
    }
   
    
}