<?php
namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Models\Coupon;
use Illuminate\Http\Request;

class CouponController extends Controller
{
    public function verify(Request $request)
    {
        $request->validate([
            'code' => 'required|string',
        ]);

        $coupon = Coupon::where('code', $request->code)->first();

        if (!$coupon) {
            return response()->json(['status' => false, 'message' => 'Coupon not found'], 404);
        }

        if (!$coupon->isValid()) {
            return response()->json(['status' => false, 'message' => 'Coupon is invalid or expired'], 400);
        }

        return response()->json([
            'status' => true,
            'message' => 'Coupon is valid',
            'data' => [
                'type' => $coupon->type,
                'value' => $coupon->value,
            ]
        ]);
    }
}
