<?php
namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use Illuminate\Support\Str;

class GoogelAuthController extends Controller
{
   /*  public function login(Request $request)


    {
        $request->validate(['id_token' => 'required|string']);

        $idToken = $request->input('id_token');

        // نتحقق من صحة الـ id_token عند Google
        $response = Http::get('https://oauth2.googleapis.com/tokeninfo', [
            'id_token' => $idToken
        ]);

        if ($response->failed()) {
            return response()->json(['message' => 'Invalid token'], 401);
        }

        $googleUser = $response->json();

        // تحقق أمان: تأكد أن الـ audience هو الـ Web client id الخاص بك
        if (!isset($googleUser['aud']) || $googleUser['aud'] !== config('services.google.client_id')) {
            return response()->json(['message' => 'Token audience mismatch'], 401);
        }

        // تحقق من الـ issuer و انتهاء الصلاحية
        if (!in_array($googleUser['iss'], ['accounts.google.com', 'https://accounts.google.com'])) {
            return response()->json(['message' => 'Invalid token issuer'], 401);
        }
        if (isset($googleUser['exp']) && $googleUser['exp'] < time()) {
            return response()->json(['message' => 'Token expired'], 401);
        }

        // تأكد من وجود email و (يفضل) تأكيد البريد
        $email = $googleUser['email'] ?? null;
        if (!$email) {
            return response()->json(['message' => 'No email provided by Google'], 422);
        }

        // email_verified قد يكون 'true' أو true
        $emailVerified = isset($googleUser['email_verified']) && ($googleUser['email_verified'] === 'true' || $googleUser['email_verified'] === true);

        // يمكنك أن تطلب من المستخدم تأكيد الإيميل محليًا لو لم يكن موثقًا
        // الآن أنشئ أو حدث المستخدم
        $user = User::updateOrCreate(
            ['email' => $email],
            [
                'name' => $googleUser['name'] ?? $email,
                'password' => bcrypt(Str::random(16)),
            ]
        );

        // إن كنت تستخدم Sanctum أو Personal Access Tokens:
        $token = $user->createToken('mobile')->plainTextToken;

        return response()->json([
            'user' => $user,
            'token' => $token,
        ]);
    } */
    public function login(Request $request)
    {
    try {
        // 1. التحقق من البيانات القادمة
        $request->validate([
            'access_token' => 'required|string',
        ]);

        $accessToken = $request->access_token;

        // 2. جلب بيانات المستخدم من Google UserInfo API
        $googleUser = Http::withToken($accessToken)
            ->get('https://www.googleapis.com/oauth2/v2/userinfo')
            ->throw() // لو حصل خطأ HTTP يرمي Exception
            ->json();

        if (!isset($googleUser['email'])) {
            return response()->json(['error' => 'Invalid Google token'], 401);
        }

        // 3. جلب بيانات إضافية من Google People API
        $peopleData = Http::withToken($accessToken)
            ->get('https://people.googleapis.com/v1/people/me', [
                'personFields' => 'phoneNumbers,addresses',
            ])
            ->throw()
            ->json();

        $phone = $peopleData['phoneNumbers'][0]['value'] ?? null;
        $city  = $peopleData['addresses'][0]['city'] ?? null;

        // 4. إنشاء أو تحديث المستخدم
        $user = User::updateOrCreate(
            ['email' => $googleUser['email']],
            [
                'full_name' => $googleUser['name'] ?? '',
                'avatar'    => $googleUser['picture'] ?? null,
                'phone'     => $phone,
                'city'      => $city,
            ]
        );

        // 5. إنشاء API Token
        $token = $user->createToken('auth_token')->plainTextToken;

        return response()->json([
            'token' => $token,
            'user'  => $user
        ]);

        } catch (\Illuminate\Http\Client\RequestException $e) {
            // لو حصل خطأ HTTP من Google API
            return response()->json([
                'error' => 'Google API request failed',
                'message' => $e->getMessage(),
                'response' => $e->response ? $e->response->json() : null
            ], 500);

        } catch (\Exception $e) {
            // أي خطأ آخر
            return response()->json([
                'error' => 'An unexpected error occurred',
                'message' => $e->getMessage()
            ], 500);
        }
    }

}


