<?php
namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Route;
use Kreait\Laravel\Firebase\Facades\Firebase;

class FaceBookAuthController  extends Controller
{
  
   /*  public function login(Request $request)
    {
      try {
            $request->validate([
                'access_token' => 'required|string',
            ]);

            $accessToken = $request->access_token;

          
            $response = Http::get("https://graph.facebook.com/me", [
                'fields' => 'id,name,email',
                'access_token' => $accessToken,
            ]);

            if ($response->failed()) {
                return response()->json([
                    'error' => 'Invalid Facebook token',
                ], 401);
            }

            $facebookUser = $response->json();

           
            $user = User::firstOrCreate(
                ['email' => $facebookUser['email'] ?? $facebookUser['id'].'@facebook.com'],
                ['name' => $facebookUser['name']]
            );

           
            $token = $user->createToken('facebook_token')->plainTextToken;

            return response()->json([
                'user' => $user,
                'token' => $token,
            ]);

        } catch (\Illuminate\Http\Client\RequestException $e) {
           
            return response()->json([
                'error' => 'Google API request failed',
                'message' => $e->getMessage(),
                'response' => $e->response ? $e->response->json() : null
            ], 500);

        } catch (\Exception $e) {
            // أي خطأ آخر
            return response()->json([
                'error' => 'An unexpected error occurred',
                'message' => $e->getMessage()
            ], 500);
        }
    } */


    public  function login (Request $request) {
    $idToken = $request->input('access_token');   

        try {
           
            $auth = Firebase::auth();
            $verifiedIdToken = $auth->verifyIdToken($idToken);

            $uid = $verifiedIdToken->claims()->get('sub');
            $firebaseUser = $auth->getUser($uid);

            $user = User::updateOrCreate(
                ['firebase_uid' => $uid],
                [
                    'name'  => $firebaseUser->displayName ?? 'No Name',
                    'email' => $firebaseUser->email ?? null,
                ]
            );

            $token = $user->createToken('mobile')->plainTextToken;

            return response()->json([
                'status' => true,
                'message' => 'Authenticated',
                'token' => $token,
                'user'  => $user
            ]);

        } catch (\Throwable $e) {
            return response()->json([
                'status' => false,
                'message' => 'Invalid Firebase token',
                'error'   => $e->getMessage()
            ], 401);
        }
    }

}


