<?php
namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Models\ModelSlider;
use App\Models\Category;
use App\Models\SparePart;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use App\Http\Resources\VendorResource;
use App\Http\Resources\CategoryResource;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\FillterResource;


class HomeController extends Controller
{
    /**
     * Constructor to set locale
     */
    public function __construct(Request $request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        App::setLocale($locale);
    }

  /* 
    public function index(Request $request)
    {
        $locale = App::getLocale(); 

       
        $sliders = ModelSlider::all()->map(function ($slider) use ($locale) {
            return [
                'id' => $slider->id,
                'image_url' => asset($slider->image_url),
                'title' => $slider->getTranslation('title',$locale) ?? '',
                'vendor_id' => $slider->vendor_id ?? null,
                'spare_part_id'=>$slider->spare_part_id ?? null,

            ];
        });

        
        $categories = Category::with('filters')->all()->map(function ($category) use ($locale) {
            return [
                'id'        => $category->id,
                'name'      => $category->getTranslation('name', $locale), // Dynamically select locale
                'image'     =>  asset('storage/' . $category->image),
                'filters'   => FillterResource::collection($category->filters),
                'is_active' => $category->is_active,
            ];
        });

        $user = Auth::user();
        $query = SparePart::where('stock', '>', 0)
                ->where('is_active', 1);

      if ($user) {
        $userCarModelIds = $user->userCars()->pluck('model_id')->toArray();
        dd($userCarModelIds);
        $userCityId = $user->city_id;

            if (!empty($userCarModelIds)) {
                $query->whereHas('models', function ($q) use ($userCarModelIds) {
                    $q->whereIn('models.id', $userCarModelIds);
                });
            }

            if ($userCityId) {
                $query->where('city_id', $userCityId);
            }

     }

       $latestSpareParts = [];

  
     $latestSpareParts = $query->with(['category', 'vendor',])
        ->latest()
        ->get()
        ->map(function ($sparePart) use ($locale) {
            return [
                'id' => $sparePart->id,
                'name' => $sparePart->getTranslation('name', $locale),
                'price' => $sparePart->price,
                'stock' => $sparePart->stock,
                'image' => $sparePart->images()->first()?->path 
                    ? asset('storage/' . $sparePart->images()->first()->path) 
                    : null,
                'discount' => null,
                'vendor_name' => $sparePart->vendor?->name[$locale] ?? null,
                'category' => $sparePart->category?->getTranslation('name', $locale),
                //'brand' => $sparePart->model?->brand?->name[$locale] ?? null,
               // 'model' => $sparePart->model?->getTranslation('name', $locale),
               // 'car_category' => $sparePart->model?->carCategory?->name[$locale] ?? null,
                'origin_country'=> $sparePart->origin_country,
                'warranty_period'=> $sparePart->warranty_period,
            ];
        });
    
            
 
        return response()->json([
            'status' => 'success',
            'message' => trans('messages.home_retrieved'),
            'data' => [
                'sliders' => $sliders,
                'categories' => $categories,
                'latest_spare_parts' => $latestSpareParts,
            ],
        ], 200);
    } */

        public function index(Request $request)
{
    $locale = App::getLocale(); 
    $user = Auth::guard('sanctum')->user();
    

    // -----------------------
    // Sliders
    // -----------------------
    $sliders = ModelSlider::select('id','image_url','title','vendor_id','spare_part_id')
        ->get()
        ->map(fn ($slider) => [
            'id' => $slider->id,
            'image_url' => asset($slider->image_url),
            'title' => $slider->getTranslation('title', $locale) ?? '',
            'vendor_id' => $slider->vendor_id,
            'spare_part_id' => $slider->spare_part_id,
        ]);

    // -----------------------
    // Categories + Filters
    // -----------------------
    $categories = Category::where('is_active', 1)
        ->with(['filters:id,category_id,key,data_type'])
        ->select('id','name','image','is_active')
        ->get()
        ->map(fn ($category) => [
            'id' => $category->id,
            'name' => $category->getTranslation('name', $locale),
            'image' => asset('storage/' . $category->image),
            'filters' => FillterResource::collection($category->filters),
            'is_active' => $category->is_active,
        ]);

    // -----------------------
    // SpareParts Query
    // -----------------------
    $query = SparePart::query()
        ->where('stock', '>', 0)
        ->where('is_active', 1)
        ->with([
            'category:id,name',
            'vendor:id,name',
            'images:id,product_id,path',
            'models:id,brand_id,name,car_category_id'
        ]);

    // -----------------------
    // Filter by user cars and city
    // -----------------------
    if ($user) {

        // Get user's car model IDs
        $userCarModelIds = $user->userCars()
            ->select('model_id')
            ->pluck('model_id');

          

        if ($userCarModelIds->isNotEmpty()) {
            // Use whereExists for better performance than whereHas
            $query->whereExists(function ($q) use ($userCarModelIds) {
                $q->selectRaw(1)
                  ->from('sparepart_model')
                  ->whereColumn('sparepart_model.spare_part_id', 'spare_parts.id')
                  ->whereIn('sparepart_model.car_model_id', $userCarModelIds);
            });
        }

        // Filter by city if set
        if ($user->city_id) {
            $query->where('city_id', $user->city_id);
        }
    }

    // -----------------------
    // Get latest spare parts
    // -----------------------
    $latestSpareParts = $query
        ->latest()
        ->limit(20) // Optional: paginate or limit for performance
        ->get()
        ->map(fn ($sparePart) => [
            'id' => $sparePart->id,
            'name' => $sparePart->getTranslation('name', $locale),
            'price' => $sparePart->price,
            'stock' => $sparePart->stock,
            'image' => optional($sparePart->images->first())->path
                ? asset('storage/' . $sparePart->images->first()->path)
                : null,
            'vendor_name' => $sparePart->vendor?->name[$locale] ?? null,
            'category' => $sparePart->category?->getTranslation('name', $locale),
            'origin_country' => $sparePart->origin_country,
            'warranty_period' => $sparePart->warranty_period,
        ]);

    // -----------------------
    // Response
    // -----------------------
    return response()->json([
        'status' => 'success',
        'message' => trans('messages.home_retrieved'),
        'data' => [
            'sliders' => $sliders,
            'categories' => $categories,
            'latest_spare_parts' => $latestSpareParts,
        ],
    ], 200);
}

}