<?php

namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Models\CarCategory;
use App\Models\Brand;
use App\Models\CarModel;
use App\Traits\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\BrandResource;
use App\Http\Resources\ModelResource;
use App\Http\Resources\EngineResource;
use App\Models\CarEngine;
use Collator;

 use App\Http\Resources\CarCategoryResource;
class MetaDataController extends Controller
{
    use ApiTrait; 

public function brands (Request $request){
     $locale = $request->header('Accept-Language', 'ar');
    $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

    if ($locale === 'ar') {
       
        $brands = Brand::all();
        $collator = new Collator('ar'); // ICU Arabic locale
        $brands = $brands->sort(function ($a, $b) use ($collator) {
            return $collator->compare(
                is_array($a->name) ? ($a->name['ar'] ?? '') : (json_decode($a->name, true)['ar'] ?? ''),
                is_array($b->name) ? ($b->name['ar'] ?? '') : (json_decode($b->name, true)['ar'] ?? '')
            );
        })->values();
    } else {
        
        $brands = Brand::orderByRaw(
            "JSON_UNQUOTE(JSON_EXTRACT(name, '$.\"$locale\"')) ASC"
        )->get();
    }
         
         
      return $this->apiResponse(true, 'brands retrieved successfully',[],BrandResource::collection($brands));


     }
    
     public function carCategories (){
        $car_categories=CarCategory::all();
        return $this->apiResponse(true, ' car categories retrieved successfully',[],CarCategoryResource::collection($car_categories));


     }


     public function Fillter_models($brand_id){
       
      $models = CarModel::where('brand_id', $brand_id)
                 
                  ->get();
        return $this->apiResponse(true, 'models  appointments retrieved successfully',[],ModelResource::collection($models));

     }

     public function fillterEngine($model_id){
        $engines = CarEngine::where('model_id', $model_id)->get();
       
        return $this->apiResponse(true, 'engines retrieved successfully',[],EngineResource::collection($engines));
     }

}