<?php

namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Http\Resources\PackageResource;
use App\Http\Resources\PackageItemResource;
use App\Http\Resources\PackageCategoryResource;

use App\Models\Package;
use App\Models\SparePart;

use Illuminate\Http\Request;
use App\Traits\ApiTrait;
use App\Models\CarModel;
class PackageController extends Controller
{
    use ApiTrait;

    /**
     * Get packages by car model id (or universal packages)
     */
    public function getByModel(CarModel $model)
    {
        try {
            $modelId = $model->id;
            $packages = Package::where('parent_id',NULL)->where(function ($q) use ($modelId) {
                    $q->whereHas('carModels', function ($q2) use ($modelId) {
                        $q2->where('car_model_id', $modelId);
                    })
                    ->orWhere('is_universal', true);
                })
                ->get();

            return $this->apiResponse(
                data: PackageResource::collection($packages),
                message: 'Packages retrieved successfully'
            );

        } catch (\Exception $e) {
            return $this->apiResponse(
               
                message: 'Error fetching packages: ' . $e->getMessage()
            );
        }
    }

    public function getPackageChildrenDetails($packageId,$model_id)
    {
        try {
            $children = Package::with('mainProducts')
            ->where('parent_id', $packageId)
            ->get();

          


            $spareParts = Package::findOrFail($packageId)->relatedProducts;


            return response()->json([
                'status' => true,
                'message' => 'Package children retrieved successfully',
                'data' => ['sub_backages'=>PackageResource::collection( $children),
                            'recommended_product'=>$spareParts]
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => $e->getMessage(),
            ], 500);
        }
    }

    public function packageCategory($packageId)
    {
        $package = Package::with('categories')->findOrFail($packageId);

         return response()->json([
            'status' => true,
            'data' =>PackageCategoryResource::collection($package->categories->map(function($cat) use ($packageId) {
        $cat->package_id = $packageId; // نضيف property مؤقت
        return $cat;
    })
)
        ]);

    }
}
