<?php

namespace App\Http\Controllers\MobileApp;

use App\Http\Controllers\Controller;
use App\Models\PackageSubscribe;
use App\Models\PackageSubscribeItem;
use Illuminate\Http\Request;
use App\Http\Resources\PackageSubscribeResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Services\VendorNotificationService;

use App\Models\Vendor;
        use Carbon\Carbon;

class PackageSubscribeController extends Controller
{

    
  

    public function getVendorsWithAvailableDays()
    {
        $vendors = Vendor::whereHas('timetables', function($q){
                $q->where('is_available', 1);
            })
           // ->where('id',108)
            ->with(['timetables' => function($q){
                $q->where('is_available', 1)
                ->select('vendor_id', 'day_of_week');
            }])
            ->get(['id', 'name']) // لو عايز كمان اسم البائع
            ->map(function($vendor){
                return [
                    'vendor_id' => $vendor->id,
                    'vendor_name' => $vendor->name ?? null,
                    'days' => $vendor->timetables->pluck('day_of_week')->unique()->values()
                ];
            });
               return response()->json([
                'status' => true,
                'message' => 'Subscription created successfully',
                'data' => $vendors,
            ]);

      //  return response()->json();
    }



    public function getAvailableSlots(Request $request)
    {
        $request->validate([
            'vendor_id' => 'required|integer|exists:vendors,id',
            'date' => 'required|date',
        ]);

        $vendorId = $request->vendor_id;
        $date = $request->date;
        $dayOfWeek = \Carbon\Carbon::parse($date)->format('l'); // Monday, Tuesday, etc.

        $timetable = \App\Models\VendorTimetable::where('vendor_id', $vendorId)
            ->where('day_of_week', $dayOfWeek)
            ->where('is_available', true)
            ->first();

        if (!$timetable) {
            return response()->json([
                'message' => 'Vendor is not available on this day.',
                'available_slots' => []
            ]);
        }

        $start = \Carbon\Carbon::parse($timetable->start_time);
        $end = \Carbon\Carbon::parse($timetable->end_time);

        $slots = [];
        while ($start->lt($end)) {
            $slots[] = $start->format('H:i');
            $start->addHour(); // slot = 1 hour
        }

        $bookedTimes = \App\Models\PackageSubscribe::whereDate('date', $date)
            ->where('vendor_id',$vendorId)
            ->pluck('time')
            ->map(function ($time) {
                    return \Carbon\Carbon::parse($time)->format('H:i');
             })
            ->toArray();

        $availableSlots = [];
        foreach ($slots as $slot) {
            $availableSlots[] = [
                'time' => $slot,
                'is_booked' => in_array($slot, $bookedTimes),
                'status' => in_array($slot, $bookedTimes) ? 'booked' : 'available'
            ];
        }

        return response()->json([
             'status' => true,
                'message' => 'Subscription created successfully',
            'vendor_id' => $vendorId,
            'day' => $dayOfWeek,
            'date' => $date,
            'data' => $availableSlots,
        ]);
    }

    
    
    
    
    
    
    public function store(Request $request)
    {
        $request->validate([
            'package_id' => 'required|exists:packages,id',
            'items' => 'required|array',
            'model_id' => 'required',
            'city_id' => 'required',
            'vendor_id'=>'nullable',
            'date' => 'nullable',
            'time' => 'nullable',
            'notes' => 'nullable',
            'items.*.product_id' => 'required|exists:spare_parts,id',
            'items.*.status' => 'nullable|string',
            'total_price' => 'required|numeric',
        ]);
        
         $user_id=Auth::id();
        
         try {
            DB::beginTransaction();
                $time = Carbon::parse($request->time)->format('H:i');

            $subscribe = PackageSubscribe::create([
                'package_id' => $request->package_id,
                'model_id' => $request->model_id,
                'city_id' => $request->city_id,
                'notes' => $request->notes,
                'date' => $request->date,
                'time' => $time,
                'user_id' =>  $user_id,
                'vendor_id'=>$request->vendor_id,
                'total_price' => $request->total_price,
            ]);

            foreach ($request->items as $item) {
                PackageSubscribeItem::create([
                    'package_subscribe_id' => $subscribe->id,
                    'product_id' => $item['product_id'],
                    'status' => $item['status'] ?? Null,
                ]);
            }

              $vendorNotifier = new VendorNotificationService();

            $vendorNotifier->BookingPackageNotification(
                 $subscribe->id, $request->vendor_id
            );

            DB::commit();

            return response()->json([
                'status' => true,
                'message' => 'Subscription created successfully',
                'data' => new PackageSubscribeResource($subscribe->load('items.product')),
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'status' => false,
                'message' => 'Error: ' . $e->getMessage(),
            ], 500);
        }
    }

    public function userSubscribes()
    {
         $user_id=Auth::id();
        $subscriptions = PackageSubscribe::where('user_id',$user_id)->with('items.product','model','city','package')->get();

        return response()->json([
            'status' => true,
            'data' => PackageSubscribeResource::collection($subscriptions),
        ]);
    }

            public function createMeeting()
        {
            $response = Http::withToken('YOUR_VCONNCT_API_TOKEN')
                ->post('https://api.vconnct.me/meetings', [
                    'topic' => 'Team Meeting',
                    'start_time' => now(),
                    'duration' => 60,
                ]);

            return response()->json($response->json());
        }   
}
