<?php

namespace App\Http\Controllers\MobileApp;

use App\Models\Vendor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;
use App\Http\Resources\VendorResource;
use App\Http\Resources\ServiceCenterResource;
use App\Traits\ApiTrait;
class ServiceCenterController extends Controller
{
    use ApiTrait;
    public function index(Request $request)
    {
        try {
            $locale = app()->getLocale();
            $cacheKey = 'services_' . $locale;

         /*    $services = Cache::remember($cacheKey, 3600, function () {
                return Vendor::with('city')
                    ->where('is_active', true)->where('type', 1)
                    ->whereNull('deleted_at')->orderBy('id')->get();
            }); */

            $services=Vendor::with('city')
                    ->where('is_active', true)->where('type', 1)
                    ->whereNull('deleted_at')->orderBy('id')->get();
            return response()->json([
                'status' => 'success',
                'message' => trans('messages.retrieve_services'),
                'data' => ServiceCenterResource::collection($services),
            ], 200);
        } catch (\Exception $e) {
            Log::error('Error retrieving services', [
                'query' => $request->all(),
                'locale' => app()->getLocale(),
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.failed_to_retrieve_vendors'),
                'debug' => app()->environment('local') ? $e->getMessage() : null,
            ], 500);
        }
    }
    public function show($id)
    {

        try {
            $locale = app()->getLocale();
            $cacheKey = "services_$id" . $locale;

            $services = Cache::remember($cacheKey, 3600, function () use ($id) {
                return Vendor::with('city')->find($id);
            });

            return response()->json([
                'status' => 'success',
                'message' => trans('messages.retrieve_services'),
                'data' => new ServiceCenterResource($services),
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.failed_to_retrieve_vendors'),
                'debug' => app()->environment('local') ? $e->getMessage() : null,
            ], 500);
        }
    }
    public function filterVendors(Request $request)
    {

        if ($request->search) {
            $services = Vendor::where('type', 1)
                ->where(function ($query) use ($request) {
                    $query->where('name->ar', 'like', '%' . $request->search . '%')
                        ->orWhere('name->en', 'like', '%' . $request->search . '%');
                })
                ->get();
            
            return  $this->apiResponse(true,'service center retrive successfully',[],[ ServiceCenterResource::collection($services)]);
        }   
        
        
        
        $cityId = $request->query('city_id');
        $repairIssueId = $request->query('repair_issue_id');

        $vendors = Vendor::where('type', 1)
            ->when($cityId, function ($query) use ($cityId) {
                $query->where('city_id', $cityId);
            })
            ->when($repairIssueId, function ($query) use ($repairIssueId) {
                $query->whereHas('repairIssues', function ($q) use ($repairIssueId) {
                    $q->where('repair_issue_id', $repairIssueId);
                });
            })
            ->with(['city', 'repairIssues.repairissue']) // eager load relations
            ->get();
        
            return  $this->apiResponse(true,'service center retrive successfully',[],[ ServiceCenterResource::collection($vendors)]);

    }
    public function searchVendors($searchTerm)
    {
        $vendors = Vendor::query()
            ->where('type', 1)
            ->where(function ($query) use ($searchTerm) {
                $query->where('name->en', 'like', "%{$searchTerm}%")
                    ->orWhere('name->ar', 'like', "%{$searchTerm}%")
                    ->orWhereHas('inspections', function ($q) use ($searchTerm) {
                        $q->where('title->en', 'like', "%{$searchTerm}%")
                            ->orWhere('title->ar', 'like', "%{$searchTerm}%")
                            ->orWhereHas('speclity', function ($q2) use ($searchTerm) {
                                $q2->where('title->en', 'like', "%{$searchTerm}%")
                                ->orWhere('title->ar', 'like', "%{$searchTerm}%");
                            });
                    });
            })
            ->with(['inspections.speclity']) 
            ->get();

        return  $this->apiResponse(true,'service center retrive successfully',[],[ ServiceCenterResource::collection($vendors)]);

    }
}