<?php
namespace App\Http\Controllers\MobileApp;

use App\Models\CarModel;
use App\Models\Model;
use App\Models\SparePart;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Resources\BrandModelResource;
use App\Http\Resources\BrandResource;
use App\Http\Resources\CarCategoryResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\ModelResource;
use Illuminate\Support\Facades\Cache;
use App\Http\Resources\SparePartResource;
use App\Http\Resources\ProductResource;
use App\Http\Resources\VendorResource;
use App\Models\Brand;
use App\Models\CarCategory;
use App\Models\Category;
use App\Models\Vendor;
use Illuminate\Support\Facades\Auth;

class SparePartController extends Controller
{
   
    public function __construct(Request $request)
    {
        $locale = $request->header('Accept-Language', 'en');
        \Illuminate\Support\Facades\App::setLocale($locale);
    }

    

    public function index(Request $request)
    {
        try {
            $locale = \Illuminate\Support\Facades\App::getLocale();
            $limit = max(1, min(100, (int) $request->query('limit', 10)));

            $search = $request->query('search', '');
            $model_id = $request->query('model_id');
            $category_id = $request->query('category_id');
            $vendor_id = $request->query('vendor_id');
            $city_id = $request->query('city_id');

            $query = SparePart::with(['category', 'vendor', 'city'])
                ->where('stock', '>', 0)
                ->where('is_active', 1);

           
            if (Auth::guard('sanctum')->user()) {
               
                $userCarModelIds = Auth::guard('sanctum')->user()->userCars()->pluck('model_id'); // Collection

                if ($userCarModelIds->isEmpty()) {
                    return response()->json([
                        'status' => 'success',
                        'message' => trans('messages.spare_parts_retrieved'),
                        'data' => [],
                        'pagination' => [
                            'current_page' => 1,
                            'last_page' => 1,
                            'per_page' => $limit,
                            'total' => 0,
                            'next_page_url' => null,
                            'prev_page_url' => null,
                        ],
                    ], 200);
                }

                // Use whereHas for the pivot relation
                $query->whereHas('models', function ($q) use ($userCarModelIds) {
                    $q->whereIn('models.id', $userCarModelIds);
                });
            }
            // 🔹 Search filter
            if (!empty($search)) {
                $query->where(function ($q) use ($search) {
                    $q->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(name, '$.en')) LIKE ?", ['%' . $search . '%'])
                        ->orWhereRaw("JSON_UNQUOTE(JSON_EXTRACT(name, '$.ar')) LIKE ?", ['%' . $search . '%'])
                        ->orWhere('description', 'LIKE', '%' . $search . '%');
                });
            }

            // 🔹 Other filters
           if (!is_null($model_id)) {
    $query->whereHas('models', function ($q) use ($model_id) {
        $q->where('models.id', $model_id);
    });
}
            if (!is_null($category_id)) {
                $query->where('category_id', $category_id);
            }
            if (!is_null($vendor_id)) {
                $query->where('vendor_id', $vendor_id);
            }
            if (!is_null($city_id)) {
                $query->where('city_id', $city_id);
            }

            $spareParts = $query->orderBy('id')->paginate($limit);

            return response()->json([
                'status' => 'success',
                'message' => trans('messages.spare_parts_retrieved'),
                'data' => SparePartResource::collection($spareParts),
                'pagination' => [
                    'current_page' => $spareParts->currentPage(),
                    'last_page' => $spareParts->lastPage(),
                    'per_page' => $spareParts->perPage(),
                    'total' => $spareParts->total(),
                    'next_page_url' => $spareParts->nextPageUrl(),
                    'prev_page_url' => $spareParts->previousPageUrl(),
                ],
            ], 200);

        } catch (\Exception $e) {
            Log::error('Error retrieving spare parts: ' . $e->getMessage(), ['trace' => $e->getTraceAsString()]);
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.failed_to_retrieve_spare_parts') . $e->getMessage(),
            ], 500);
        }
    }


 
    public function show(Request $request, $id)
    {
        try {
            $locale = \Illuminate\Support\Facades\App::getLocale();

           // $sparePart = Cache::remember('spare_part_' . $id . '_' . $locale, 3600, function () use ($id) {
                $sparePart = SparePart::with(['category', 'vendor'])
                   // ->where('is_active', true)
                    ->findOrFail($id);
           // });
              $relatedSpareParts = SparePart::where('id', '!=', $sparePart->id)
                ->where('category_id', $sparePart->category_id)
                ->where('model_id', $sparePart->model_id)
                ->where('is_active', true) // optional
                ->where('stock', '>', 0)   // or 'stok', depending on your actual column
                ->get();
            return response()->json([
                'status' => 'success',
                'message' => trans('messages.spare_part_retrieved'),
                'data' => new ProductResource($sparePart),
                'related_product'=> ProductResource::collection($relatedSpareParts),
            ], 200);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.spare_part_not_found'),
            ], 404);
        } catch (\Exception $e) {
            Log::error('Error retrieving spare part: ' . $e->getMessage(), ['trace' => $e->getTraceAsString()]);
            return response()->json([
                'status' => 'error',
                //   'message' => trans('messages.failed_to_retrieve_spare_part'),
                'message' => $e->getMessage(),

                // Remove error message in production for security
                // 'error' => $e->getMessage(),
            ], 500);
        }
    }
    public function dataSearch()
    {
        return response()->json([
            'status' => 'success',
            'message' => trans('messages.spare_part_retrieved'),
            'car-category' => CarCategoryResource::collection(CarCategory::all()),
            'brands' => BrandModelResource::collection(Brand::all()),
            'category' => CategoryResource::collection(Category::where('is_active', 1)->where('parent_id', null)->get()),
        ], 200);
    }
}