<?php

namespace App\Http\Controllers\MobileApp;

use App\Http\Resources\WinchResource;
use App\Models\Winch;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class WinchController extends Controller
{
    public function index(Request $request)
    {
        $perPage = $request->query('per_page', 15); // Default to 15 items per page
        $winches = Winch::where('user_id', auth()->id())->paginate($perPage);

        return response()->json([
            'status' => 'success',
            'data' => WinchResource::collection($winches),
            'pagination' => [
                'current_page' => $winches->currentPage(),
                'last_page' => $winches->lastPage(),
                'per_page' => $winches->perPage(),
                'total' => $winches->total(),
                'next_page_url' => $winches->nextPageUrl(),
                'prev_page_url' => $winches->previousPageUrl()
            ]
        ], 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'phone_number' => 'required|string|max:15',
            'model_id' => 'required',
            'current_address' => 'required|string|max:255',
            'destination_address' => 'required|string|max:255',
            'issue' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors()
            ], 422);
        }

        $data = $validator->validated();
        $data['user_id'] = auth()->id();
        $data['status'] = 'pending';

        $winch = Winch::create($data);

        return response()->json([
            'status' => 'success',
            'message' => 'Winch created successfully',
            'data' => new WinchResource($winch)
        ], 201);
    }
    public function destroy($id)
    {
        $winch = Winch::where('user_id', auth()->id())->find($id);

        if (!$winch) {
            return response()->json([
                'status' => 'error',
                'message' => 'Winch request not found.'
            ], 404);
        }

        $winch->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'Winch request deleted successfully.'
        ], 200);
    }

}