<?php

namespace App\Http\Controllers\Provider;

use App\Models\SiteDetail;
use Illuminate\Http\Request;
use App\Http\Requests\Provider\RegistrationRequest;
use App\Http\Requests\Provider\LoginRequest;
use App\Http\Controllers\Controller;
use App\Http\Resources\GovernorateResource;
use App\Models\Vendor;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\SiteDetailResource;
use Illuminate\Support\Facades\Auth;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Governorate;
use Illuminate\Support\Facades\Mail;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\BrandResource;
use App\Traits\ApiTrait;
use App\Mail\PasswordReset;
use Illuminate\Support\Facades\DB;
use Collator;


class AuthController extends Controller
{
     use ApiTrait;
        public function __construct(Request $request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';
        \Illuminate\Support\Facades\App::setLocale($locale);
    }
    public function registration(RegistrationRequest $request)
    {
       
         $provider = Vendor::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'address' => $request->address,
            'city_id' => $request->city_id,
            'fcm_token'=>$request->fcm_token,
            'type'=>$request->type,
            'phone'=>$request->phone,
        ]);

        $provider->categories()->sync($request->category_ids);
        $provider->brands()->sync($request->brand_ids);

         $provider->wallet()->create();
         $token = $provider->createToken('provider-token')->plainTextToken;

        return response()->json([
            'status' => true,
            'message' => 'Provider created successfully',
            'token' =>$token,
            'data' => $provider->load('categories'),
        ]);
    }
    public function login(LoginRequest $request)
    {
        $provider = Vendor::where('phone', $request->phone)->first();

        if (!$provider || !Hash::check($request->password, $provider->password)) {
            return response()->json([
                'status' => false,
                'message' => trans('messages.invalid_credentials'),
            ], 401);
        }
        if (!$provider || !Hash::check($request->password, $provider->password)) {
            return response()->json([
                'status' => false,
                'message' => trans('messages.invalid_credentials'),
            ], 401);
        }

        $token = $provider->createToken('provider-token')->plainTextToken;

        return response()->json([
            'status' => true,
            'message' =>trans('messages.user_logged_in'),
            'token' => $token,
            'provider' => $provider,
        ]);
    }
    public function getCategoriesAndCities(Request $request)
    {


        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        if ($locale === 'ar') {
        
            $brands = Brand::all();
            $collator = new Collator('ar'); // ICU Arabic locale
            $brands = $brands->sort(function ($a, $b) use ($collator) {
                return $collator->compare(
                    is_array($a->name) ? ($a->name['ar'] ?? '') : (json_decode($a->name, true)['ar'] ?? ''),
                    is_array($b->name) ? ($b->name['ar'] ?? '') : (json_decode($b->name, true)['ar'] ?? '')
                );
            })->values();
        } else {
            
            $brands = Brand::orderByRaw(
                "JSON_UNQUOTE(JSON_EXTRACT(name, '$.\"$locale\"')) ASC"
            )->get();
        }
        $categories = Category::all();
        $states = Governorate::with('cities')->get();
      
        return response()->json([
                'status' => true,
                'message' => 'Data retrieved successfully',
                'data' => [
                    'categories' => CategoryResource::collection($categories),
                    'Governments' => GovernorateResource::collection($states),
                    'brands' =>BrandResource::collection($brands),
                ],
            ]);

    }
    public function sendOtp(Request $request)
    {
        $request->validate(['email' => 'required|email|exists:vendors,email']);

        $otp = rand(100000, 999999);

        DB::table('otps')->updateOrInsert(
            ['email' => $request->email],
            [
                'otp' => $otp,
                'is_verified' => false,
                'expires_at' => now()->addMinutes(10),
                'updated_at' => now(),
            ]
        );

        $user = \App\Models\Vendor::where('email', $request->email)->first();
        Mail::to($user->email)->send(new PasswordReset($otp, $user)); // reuse mail template

        return response()->json([
            'status' => true,
            'message' => 'OTP sent to your email.'
        ]);
    }
    public function verifyOtp(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'otp' => 'required'
        ]);

        $otpRecord = DB::table('otps')
            ->where('email', $request->email)
            ->where('otp', $request->otp)
            ->first();

        if (!$otpRecord || $otpRecord->expires_at < now()) {
            return response()->json([
                'status' => false,
                'message' => 'Invalid or expired OTP.'
            ], 422);
        }

        DB::table('otps')
            ->where('email', $request->email)
            ->update(['is_verified' => true]);

        return response()->json([
            'status' => true,
            'message' => 'OTP verified successfully.'
        ]);
    }
    public function resetPassword(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required|min:6'
        ]);

        $otpRecord = DB::table('otps')
            ->where('email', $request->email)
            ->where('is_verified', true)
            ->first();

        if (!$otpRecord) {
            return response()->json([
                'status' => false,
                'message' => 'OTP not verified for this email.'
            ], 422);
        }

        $user = \App\Models\Vendor::where('email', $request->email)->first();
        $user->update([
            'password' => Hash::make($request->password) // Proper way to hash
        ]);

       
        DB::table('otps')->where('email', $request->email)->delete();

        return response()->json([
            'status' => true,
            'message' => 'Password reset successfully.'
        ]);
     }
     
     public function logout(Request $request)
    {
            $request->user()->currentAccessToken()->delete();
            return $this->apiResponse(true, 'Logged out successfully', [], []);

    }
    public function deleteAccount(Request $request)
    {
        $vendor = auth('sanctum')->user(); 

        if (!$vendor) { 
         return $this->apiResponse(true, 'Unauthorized.', [], []);
        }
        $vendor->tokens()->delete();
        $vendor->delete();

      return $this->apiResponse(true, 'your acount deleted successfuly.', [], []);

    }
     
    public function deleteByPhone($phone)
    {
        $user = Vendor::where('phone', $phone)->first();

        if (!$user) {
            return response()->json([
                'status' => false,
                'message' => 'Vendor not found',
            ], 200);
        }

        $user->delete();

        return response()->json([
            'status' => true,
            'message' => 'Vendor deleted successfully',
        ], 200);
    }


}