<?php
namespace App\Http\Controllers\Provider;

use Illuminate\Http\Request;
use App\Models\Feedback;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Resources\FeedbackResource;
use App\Http\Requests\MobileApi\StoreFeedbackRequest;
use App\Mail\HelpMessageMail;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    /**
     * Constructor to set locale (remove if using SetLocale middleware)
     */
    public function __construct(Request $request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';
        \Illuminate\Support\Facades\App::setLocale($locale);
    }

    /**
     * Store feedback
     *
     * @param StoreFeedbackRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(StoreFeedbackRequest $request)
    {
        try {
            $data = $request->validated();

            DB::beginTransaction();

            $feedback = Feedback::create([
                'name' => $data['name'],
                'phone' => $data['phone'],
                'message' => $data['message'],
                'type' => "help_message",
            ]);


            Mail::to('kajagox725@7tul.com')->send(
                        new HelpMessageMail(
                            $feedback->name,
                            $feedback->message
                           
                        )
                    );

            DB::commit();

            return response()->json([
                'status' => 'success',
                'message' => trans('messages.feedback_submitted_successfully'),
                'data' => new FeedbackResource($feedback),
            ], 200);
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error submitting feedback', [
                'data' => $request->all(),
                'locale' => app()->getLocale(),
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
            return response()->json([
                'status' => 'error',
                'message' => trans('messages.failed_to_submit_feedback'),
                'debug' => app()->environment('local') ? $e->getMessage() : null,
            ], 500);
        }
    }
   
  
}