<?php

namespace App\Http\Controllers\Provider;

use App\Models\Notification;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use App\Traits\ApiTrait;
class NotificationController extends Controller
{
      use ApiTrait;
     public function index(Request $request)
    {
        $vendor = auth()->user();
        $limit = $request->query('limit', 10); // Default to 10 notifications

        $notifications = $vendor->notification()
            ->take($limit)
            ->latest()
            ->get()
            ->map(function ($notification) {
                return [
                    'id' => $notification->id,
                    'type' => $notification->type,
                    'title'=>$notification->title,
                    'message' => $notification->message,
                    'read_at' => $notification->read_at,
                    'created_at' => $notification->created_at,
                ];
            });

            return $this->apiResponse(true, 'Notificaation retrived  successfuly.', [], $notifications);

    }
    public function markAsRead(Request $request){
        $vendor = auth()->user();
        $vendor->notification()
                    ->where('is_read', false)
                    ->update([
                        'is_read' => true,
                        'read_at' => now(),
                    ]);
        return $this->apiResponse(true, 'Notification marked as read successfully.', [], []);
    }

   
   
    public function getUnreadCount(Request $request)
    {
        try {
            $vendor = auth()->user();

            if (!$vendor) {
                return response()->json([
                    'message' => 'Unauthenticated.',
                ], 401);
            }
            $unreadCount = Notification::where('vendor_id', $vendor->id)
                ->where('is_read', false)
                ->count();

            return response()->json([
                'message' => 'Unread notification count retrieved successfully.',
                'count' => $unreadCount,
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'message' => 'An error occurred while retrieving the notification count.',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
    public function delete($id){
        $notification = Notification::find($id);
        $notification->delete();
        return $this->apiResponse(true, 'Notification deleted successfully.', [], []);
    }
   
    public function deleteAll(){
        $vendor = auth()->user();
        $vendor->notification()->delete();
        return $this->apiResponse(true, 'All notifications deleted successfully.', [], []);
    }
}