<?php
namespace App\Http\Controllers\Provider;

use App\Http\Resources\ProductResource;
use App\Models\Product;
use App\Http\Controllers\Controller;
use App\Http\Requests\Provider\ProductRequest;
use Illuminate\Http\Request;
use App\Traits\ApiTrait;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;

class OfferController extends Controller
{
    use ApiTrait;
   
    public function index()
    {
       
         $vendor = auth()->user();
          
      
            $now = Carbon::now();

           
            $activeOffers = $vendor->products()
                ->whereNotNull('offer_starts_at')
                ->where(function ($query) use ($now) {
                    $query->whereNull('offer_ends_at')
                        ->orWhere('offer_ends_at', '>=', $now);
                })
                ->with('images')
                ->latest()
                ->get();

            
            $expiredOffers = $vendor->products()
                ->whereNotNull('offer_starts_at')
                ->whereNotNull('offer_ends_at')
                ->where('offer_ends_at', '<', $now)
                ->with('images')
                ->latest()
                ->get();
            

            return $this->apiResponse(true, 'offers retrieved successfully', [],["activeOffers"=> ProductResource::collection($activeOffers),"expiredOffers"=>ProductResource::collection($expiredOffers)]);
    }

  
    public function store(ProductRequest $request)
    {
        $validated = $request->validated();
       
        $vendor = auth()->user();
      
        $offer = $vendor->products()->create($validated);
        $offer->category->is_active=1;
        $offer->category->save();
 
          if ($request->hasFile('images')) {
            $uploadedImages = [];
            
            foreach ($request->file('images') as $image) {
                $path = $image->store('product_images', 'public');
                $uploadedImages[] = ['path' => $path];
            }
            
            $offer->images()->createMany($uploadedImages);
       }
        
       return $this->apiResponse(true, 'offer created  successfully', [],new ProductResource($offer));
  

    }
    public function update( $id,ProductRequest $request){
    
   
          $product = Product::findOrFail($id);

            $data = $request->validated();

          foreach (['offer_starts_at', 'offer_ends_at'] as $field) {
                if (empty($data[$field]) || $data[$field] === 'null') {
                    $data[$field] = null;
                }
            }

            $product->update($data);
       
        if ($request->hasFile('images')) {
                $uploadedImages = [];

                foreach ($request->file('images') as $image) {
                    $path = $image->store('product_images', 'public');
                    $uploadedImages[] = ['path' => $path];
                }

                $product->images()->createMany($uploadedImages);
        }
       
         return $this->apiResponse(true, 'offer updated successfully', [], new ProductResource($product->fresh()));

    }
 
    public function destroy($id){
        
        
        $product = Product::with('images')->findOrFail($id);

        foreach ($product->images as $image) {
            Storage::disk('public')->delete($image->path);
            $image->delete();
        }

        $product->delete();

        return $this->apiResponse(true, 'Product and its images deleted successfully',[],[]);

    }

        public function deleteProductImage($imageId)
        {
            $image = ProductImage::findOrFail($imageId);

            Storage::disk('public')->delete($image->path);

            $image->delete();

            return $this->apiResponse(true, 'Product image deleted successfully');
        }
    
}