<?php
namespace App\Http\Controllers\Provider;

use Exception;
use Carbon\Carbon;
use App\Models\City;
use App\Models\User;
use App\Models\ContactUs;
use App\Mail\PasswordReset;
use App\Models\Governorate;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Resources\AppointmentResource;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\GovernorateResource;
use App\Http\Resources\PackageSubscribeResource;
use Illuminate\Validation\ValidationException;
use App\Models\VendorTimetable;
use App\Models\PackageSubscribe;
use App\Models\VendorInspection;
use App\Traits\ApiTrait;
use App\Models\PackageSubscribeItem;
use App\Models\SparePart;
 
class PackageSubscribeController extends Controller
{
 use ApiTrait; 
  public function index()

  {
    
      $vendor = auth('sanctum')->user();
      $pending_subscribe = PackageSubscribe::where('vendor_id', $vendor->id)->where('status','pending')->with('model','package','items.product','city')->latest()->paginate(10, ['*'], 'pending_page');
      $completed_subscribe = PackageSubscribe::where('vendor_id', $vendor->id)->where('status','completed')->with('model','package','items.product','city')->latest()->paginate(10, ['*'], 'completed_page');


     return $this->apiResponse(true, 'subscribe retrieved successfully',[],["pending_subscribe"=>PackageSubscribeResource::collection($pending_subscribe)->response()->getData(true),"completed_subscribe"=>PackageSubscribeResource::collection($completed_subscribe)->response()->getData(true)]);
   }


public function addItemByBarcode(Request $request)
{
    $request->validate([
        'package_subscribe_id' => 'required|exists:package_subscribes,id',
        'barcode' => 'required|string',
    ]);

    $subscribe = PackageSubscribe::findOrFail($request->package_subscribe_id);

    $product = SparePart::where('barcode', $request->barcode)->first();

    if (!$product) {
          return $this->apiResponse(false, 'المنتج غير موجود',[],[],404);
    }

    $exists = PackageSubscribeItem::where('package_subscribe_id', $subscribe->id)
        ->where('product_id', $product->id)
        ->exists();

    if ($exists) {
         return $this->apiResponse(false,'المنتج متضاف بالفعل',[],[],422);
     }

    $item = PackageSubscribeItem::create([
        'package_subscribe_id' => $subscribe->id,
        'product_id' => $product->id,
        'status' => Null,
        'product_status' => Null,
    ]);

    $subscribe->total_price+=$product->price;

    $subscribe->save();

    return  $this->apiResponse(
        true,
         'تم إضافة المنتج بنجاح',[],[]);
}

public function changeStatus(Request $request, PackageSubscribe $subscribe)
{
    $request->validate([
        'status' => 'required|in:completed,canceled,pending',
    ]);

    $subscribe->status = $request->status;
    $subscribe->save();

    // رسالة حسب الحالة
    $message = match ($request->status) {
        'completed' => 'تم إكمال فاتورة الاشتراك بنجاح',
        'canceled'  => 'تم إلغاء الاشتراك',
        default     => 'تم تحديث حالة الاشتراك',
    };

    return $this->apiResponse(true, $message, [], []);
}



}