<?php
namespace App\Http\Controllers\Provider;

use App\Http\Resources\ProductResource;
use App\Models\Product;
use App\Models\Category;
use App\Models\CarCategory;
use App\Models\Brand;
use App\Http\Controllers\Controller;
use App\Http\Requests\Provider\ProductRequest;
use Illuminate\Http\Request;
use App\Traits\ApiTrait;
use Illuminate\Support\Facades\Storage;
use App\Http\Resources\SparePartResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\CarCategoryResource;
use App\Http\Resources\BrandModelResource;
use App\Models\SparePart;
use App\Models\SparePartFilter;

class ProductController extends Controller
{
    use ApiTrait;
   
    public function index()
    {
        $vendor = auth()->user();

        $products = $vendor->products()
                ->whereNull('offer_starts_at')
                ->whereNull('offer_ends_at')
                ->with('images')
                ->latest()
                ->get();

        return $this->apiResponse(true, 'Products retrieved successfully', [], ProductResource::collection($products));
    }

    
    public function store(ProductRequest $request)
    {
        $validated = $request->validated();
       
        $vendor = auth()->user();
      
        $product = $vendor->products()->create($validated);
        $product->category->is_active=1;
        $product->category->save();
 
       /*  if ($request->hasFile('images')) {
            $uploadedImages = [];
            
            foreach ($request->file('images') as $image) {
                $path = $image->store('product_images', 'public');
                $uploadedImages[] = ['path' => $path];
            }
            
            $product->images()->createMany($uploadedImages);
        } */
        if ($request->hasFile('images')) {
                $uploadedImages = [];

                foreach ($request->file('images') as $image) {
                    $filename = time() . '_' . uniqid() . '.' . $image->getClientOriginalExtension();

                    $image->move(public_path('storage/product_images'), $filename);

                    $uploadedImages[] = ['path' => 'product_images/' . $filename];
                }
                

                $product->images()->createMany($uploadedImages);
            }
        
        if ($request->has('filters')) {
                foreach ($request->filters as $filterData) {
                SparePartFilter::create([
                    'spare_part_id'      => $product->id,
                    'category_filter_id' => $filterData['id'],
                    'value'              => $filterData['value'],
                ]);
            }
        }
       
        
       return $this->apiResponse(true, 'product created  successfully', [],new SparePartResource($product));
  

    }
  
  
  
    public function update( $id,ProductRequest $request){
    
    
           $product = SparePart::findOrFail($id);

            $data = $request->validated();

          foreach (['offer_starts_at', 'offer_ends_at'] as $field) {
                if (empty($data[$field]) || $data[$field] === 'null') {
                    $data[$field] = null;
                }
            }

            $product->update($data);
       
/*             if ($request->hasFile('images')) {
                    $uploadedImages = [];

                    foreach ($request->file('images') as $image) {
                        $path = $image->store('product_images', 'public');
                        $uploadedImages[] = ['path' => $path];
                    }

                    $product->images()->createMany($uploadedImages);
            } */
           if ($request->hasFile('images')) {
                $uploadedImages = [];

                foreach ($request->file('images') as $image) {
                    $filename = time() . '_' . uniqid() . '.' . $image->getClientOriginalExtension();

                    $image->move(public_path('storage/product_images'), $filename);

                    $uploadedImages[] = ['path' => 'product_images/' . $filename];
                }
               

                $product->images()->createMany($uploadedImages);
            }
           
            if ($request->has('filters')) {
                foreach ($request->filters as $filterData) {
                    SparePartFilter::updateOrCreate(
                        [
                            'spare_part_id'      => $product->id,
                            'category_filter_id' => $filterData['id'],
                        ],
                        [
                            'value' => $filterData['value'],
                        ]
                    );
                }
            }
       
         return $this->apiResponse(true, 'Product updated successfully', [], new ProductResource($product->fresh()));

    }
 
    
    
    public function destroy($id){
        
        
        $product = SparePart::with('images')->findOrFail($id);

        foreach ($product->images as $image) {
            Storage::disk('public')->delete($image->path);
            $image->delete();
        }

        $product->delete();

        return $this->apiResponse(true, 'Product and its images deleted successfully',[],[]);

    }
     public function show($id){
        
        
        $product = SparePart::with('images')->findOrFail($id);

       
        return $this->apiResponse(true, 'product retrieved successfully', [],new ProductResource($product));

    }

   
   
    public function deleteProductImage($imageId)
    {
        $image = ProductImage::findOrFail($imageId);

        Storage::disk('public')->delete($image->path);

        $image->delete();

        return $this->apiResponse(true, 'Product image deleted successfully');
    }
  
  
   
   
    public function metaData(){
        $lang = app()->getLocale();
        $categories=Category::all();
        $car_categories=CarCategory::all();
       $brands = Brand::with('models')  
            ->whereHas('models') 
            ->get();
        $lowestPrice = SparePart::min('price');
        $lowestPrice = SparePart::selectRaw('MIN(CAST(price AS DECIMAL(10,2))) as min_price')->value('min_price');
        $maxPrice = SparePart::selectRaw('Max(CAST(price AS DECIMAL(10,2))) as min_price')->value('min_price');

        return $this->apiResponse(true, 'meta data',[],['categories'=>CategoryResource::collection($categories),'brands'=>BrandModelResource::collection($brands),'lowestPrice'=>$lowestPrice,'maxPrice'=>$maxPrice]);

    }
   
    
    
    public function filter(Request $request)
    {
        $vendor = auth()->user();

        $query = $vendor->products();


       if ($request->filled('search')) {
            $products = $this->searchProductsByTerm($request, $vendor);

            if ($products->isEmpty()) {
                return $this->apiresponse(false, 'No product found');
            }

            return $this->apiresponse(true, 'Products found', [], ProductResource::collection($products));
      }

   
        $query->when($request->category_id, fn($q) => $q->where('category_id', $request->category_id));
        $query->when($request->car_category_id, fn($q) => $q->where('car_category_id', $request->car_category_id));
        $query->when($request->brand_id, fn($q) => $q->where('brand_id', $request->brand_id));
        $query->when($request->model_id, fn($q) => $q->where('model_id', $request->model_id));
       $query->when($request->price_from, fn($q) =>
       $q->whereRaw('CAST(price AS DECIMAL(10,2)) >= ?', [$request->price_from])
        );

        $query->when($request->price_to, fn($q) =>
            $q->whereRaw('CAST(price AS DECIMAL(10,2)) <= ?', [$request->price_to])
        );

      
        if ($request->filled('is_offer')) {
            if ($request->is_offer == 1) {
                $query->whereNotNull('offer_starts_at');
            } elseif ($request->is_offer == 0) {
                $query->whereNull('offer_starts_at');
            }
        }

        $products = $query->latest()->get();
        return $this->apiresponse(true,'filterd data retrived',[],ProductResource::collection($products));

    
    }
    private function searchProductsByTerm(Request $request, $vendor)
    {
        $search = $request->search;

        $query = $vendor->products()
            ->where(function ($q) use ($search) {
                $q->whereRaw("LOWER(JSON_UNQUOTE(JSON_EXTRACT(name, '$.ar'))) LIKE ?", ['%' . strtolower($search) . '%'])
                ->orWhereRaw("LOWER(JSON_UNQUOTE(JSON_EXTRACT(name, '$.en'))) LIKE ?", ['%' . strtolower($search) . '%']);
            });

      
        if ($request->filled('is_offer')) {
            if ($request->is_offer == 1) {
                $query->whereNotNull('offer_starts_at');
            } elseif ($request->is_offer == 0) {
                $query->whereNull('offer_starts_at');
            }
        }

        return $query->latest()->get();
    }

   

    
}