<?php
namespace App\Http\Controllers\Provider;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use App\Http\Resources\VendorResource;

class ProfileController extends Controller
{
    use \App\Traits\ApiTrait; 

    public function show()
    {
        $vendor = auth()->user();
        return $this->apiResponse(true, 'Profile retrieved successfully', [], new VendorResource($vendor));
    }

    
    public function update(Request $request)
    {
        $vendor = auth()->user();

        $data = $request->only([
            'name', 'email', 'phone', 'city_id', 'address', 'description', 'image'
        ]);

        if ($request->hasFile('image')) {
            if ($vendor->image) {
                Storage::disk('public')->delete($vendor->image);
            }

            $data['image'] = $request->file('image')->store('vendor_images', 'public');
        }

        $vendor->update($data);

        return $this->apiResponse(true, 'Profile updated successfully', [], new VendorResource($vendor->fresh()));
    }
     

    public function changePassword(Request $request)
    {
      
        $request->validate([
            'old_password' => 'required|string',
            'new_password' => 'required|string|min:6|confirmed',
        ]);

        $user  = auth()->user();


       
        if (!Hash::check($request->old_password, $user->password)) {
            return $this->apiResponse(false, 'Old password is incorrect', 422);
        }

       
        $user->password = Hash::make($request->new_password);
        $user->save();

        return $this->apiResponse(true, 'Password changed successfully');
    }
    

}
