<?php
namespace App\Http\Controllers\Provider;
use App\Http\Controllers\Controller;

use App\Models\CustomPartRequest;
use App\Traits\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


use App\Http\Resources\CustomPartRequestResource;
use App\Http\Resources\WalletResource;

class ProviderHomeController extends Controller
{
    use ApiTrait;
    public function index()
    {
       
        $vendor = Auth::guard('sanctum')->user();

        if (!$vendor) {
          
            return $this->apiResponse(false, 'Vendor not authenticated', [], []);

        }
        
       
            $vendorCityId = $vendor->city_id;
            $vendorBrandIds = $vendor->brands()->pluck('brands.id');


            $vendorId = $vendor->id;
          
                                
            $requests = CustomPartRequest::where('city_id', $vendorCityId)
                ->whereHas('model', function ($query) use ($vendorBrandIds) {
                    $query->whereIn('brand_id', $vendorBrandIds);
                })
                ->with([
                    'model.brand',
                    'category',
                    'city',
                    'items.itemOffers'
                ])->latest()
                ->get()
                // For each request, filter the items:
                ->map(function ($request) use ($vendorId) {
                    // Filter items in this request:
                    $filteredItems = $request->items->filter(function ($item) use ($vendorId) {
                        // Check each offer of the item:
                        foreach ($item->itemOffers as $offer) {
                            // If an item has an offer from the current vendor, exclude it.
                            if ($offer->vendor_id == $vendorId) {
                                return false;
                            }
                            // If an item has an offer from any other vendor whose status is accepted or completed, exclude it.
                            if ($offer->vendor_id != $vendorId && in_array($offer->status, ['accepted', 'completed'])) {
                                return false;
                            }
                        }
                        // If none of the above conditions matched, keep this item.
                        return true;
                    });

                    // Replace the items relation with only the valid items:
                    $request->setRelation('items', $filteredItems);
                    return $request;
                })
                // Finally, remove any request that, after filtering, ends up with zero items:
                ->filter(function ($request) {
                    return $request->items->count() > 0;
                })
                ->values();

        $vendor_wallet=$vendor->wallet;
      
        return $this->apiResponse(true, 'home data  for auth retrived successfully not authenticated', [],['pending_request'=>CustomPartRequestResource::collection($requests),'wallet'=>new WalletResource($vendor_wallet)]);

    }
}
