<?php
namespace App\Http\Controllers\Provider;
use App\Traits\ApiTrait;

use App\Models\SparePart;
use Illuminate\Http\Request;
use App\Models\SparePartOffer;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\CustomPartRequestItem;
use App\Http\Resources\SparePartResource;
use App\Services\UserNotificationService;
use App\Services\FirebaseNotificationService;
use App\Http\Resources\CustomPartRequestResource;

class SparePartController extends Controller
{
    use ApiTrait;
   public function store(Request $request)
{
    $validated = $request->validate([
        'custom_part_request_id' => 'required|exists:custom_part_request_items,id',
        'price' => 'required|numeric',
        'warranty_period' => 'nullable|string',
        'files' => 'nullable|array',
        'files.*' => 'file|mimes:jpeg,png,jpg,gif,mp4,mov,avi|max:10240', // max 10MB per file
    ]);

    $vendor = auth()->user();

    $offer = SparePartOffer::create([
        'item_id' => $validated['custom_part_request_id'],
        'vendor_id' => $vendor->id,
        'price' => $validated['price'],
        'warranty_period' => $validated['warranty_period'] ?? null,
        'status' => 'pending',
    ]);

    if ($request->hasFile('files')) {
        foreach ($request->file('files') as $file) {
            $path = $file->store('offers_files', 'public');

            $offer->files()->create([
                'file_path' => $path,
                'file_type' => $file->getClientOriginalExtension(),
            ]);
        }
    }
    
    $user_id=CustomPartRequestItem::find($request->custom_part_request_id)->customPartRequest->user->id ;      
 
    $vendorNotifier = new UserNotificationService();

    $vendorNotifier->notifyaddoffer(
                $user_id,
                $offer->id,    
                null
            );

    return response()->json([
        'status' => 'success',
        'message' => 'Offer created successfully',
        'data' => $offer->load('files'),
    ], 201);
 }



 // get some product to show as visitor
 public function index(){
     return response()->json([
        'status' => 'success',
        'message' => 'spare part created successfully',
        'data' => SparePartResource::collection(SparePart::with([ 'vendor', 'model','category','brand','city','cartItems', 'orderItems', 'images'
             ])->latest()->take(10)->get())
        ], 201);
 }

}