<?php
namespace App\Http\Controllers\Provider;
use App\Http\Controllers\Controller;

use App\Models\CustomPartRequest;
use App\Traits\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\CustomPartRequestResource;

class SparePartOrderController extends Controller
{
    use ApiTrait;
    public function vindorOrders()
    {
       
        $vendor = Auth::guard('sanctum')->user();

        if (!$vendor) {
          
            return $this->apiResponse(false, 'Vendor not authenticated', [], []);

        }
        
       
        $vendorCityId = $vendor->city_id;
        $vendorBrandIds = $vendor->brands()->pluck('brands.id');

      
      /*   $orders = CustomPartRequest::where('city_id', $vendorCityId)
            ->whereHas('model', function ($query) use ($vendorBrandIds) {
                $query->whereIn('brand_id', $vendorBrandIds);
            })
            ->with(['model.brand', 'category', 'items', 'city']) 
            ->get(); */

      
        $vendorId=$vendor->id;
/*         $requests = CustomPartRequest::where('city_id', $vendorCityId)
                                    ->whereHas('model', function ($query) use ($vendorBrandIds) {
                                        $query->whereIn('brand_id', $vendorBrandIds);
                                    })
                                    ->whereDoesntHave('sparePartOffers', function ($query) use ($vendorId) {
                                        $query->where('vendor_id', $vendorId);
                                    }) // Exclude requests already offered by this vendor
                                    ->whereDoesntHave('sparePartOffers', function ($query) {
                                        $query->where('status', 'accepted');
                                    }) // Exclude requests with any accepted offers
                                    ->where(function ($query) use ($vendorId) {
                                        $query->whereDoesntHave('sparePartOffers') // No offers at all
                                            ->orWhereHas('sparePartOffers', function ($q) use ($vendorId) {
                                                $q->where('vendor_id', '!=', $vendorId)
                                                    ->where('status', 'pending'); // Only pending offers from others
                                            });
                                    })
                                    ->with([
                                        'model.brand',
                                        'category',
                                        'items',
                                        'city',
                                        'sparePartOffers' => function ($query) use ($vendorId) {
                                            $query->where('vendor_id', '!=', $vendorId)
                                                ->where('status', 'pending');
                                        }
                                    ])
                                    ->get(); */


        
        
       /*   $requests = CustomPartRequest::whereHas('items.itemOffers', function ($query) use ($vendorId) {
                $query->where('vendor_id', $vendorId)
                    ->where('status', 'pending');
            })
            ->with(['items.itemsOffers' => function ($query) use ($vendorId) {
                $query->where('vendor_id', $vendorId)
                    ->where('status', 'pending');
            }])
            ->get();  */  
           /*  $requests = CustomPartRequest::whereHas('items.itemOffers', function ($query) use ($vendorId) {
                $query->where('vendor_id', $vendorId)
                    ->where('status', 'pending');
            })
            ->whereDoesntHave('items.itemOffers',function($query) use ($vendorId) {
                $query->where('vendor_id', $vendorId)
                  ->where('status', 'pending');
            })
            ->OrwhereDoesntHave('items.itemOffers')
            ->with(['items.itemOffers' => function ($query) use ($vendorId) {
                $query->where('vendor_id', $vendorId)
                    ->where('status', 'pending');
            }])
            ->get();  */
            $requests = CustomPartRequest::whereDoesntHave('items.itemOffers', function ($query) {
                    $query->where('status', 'accepted');
                })->whereDoesntHave('items.itemOffers', function ($query) use ($vendorId) {
                    $query->where('vendor_id', $vendorId)
                        ->where('status', 'pending');
                })
                 ->whereHas('model', function ($query) use ($vendorBrandIds) {
                    $query->whereIn('brand_id', $vendorBrandIds);
                })->where('city_id', $vendorCityId)
                ->with(['items.itemOffers' => function ($query) {
                    $query->where('status', 'pending');
                }])->latest()
                ->get();
        
        $requests_waiting = CustomPartRequest::whereHas('items.itemOffers', function ($query) use ($vendorId) {
                    $query->where('vendor_id', $vendorId)
                        ->where('status', 'pending');
                })
                ->with(['items.itemOffers' => function ($query) use ($vendorId) {
                    $query->where('vendor_id', $vendorId)
                        ->where('status', 'pending');
                },'items'])
                ->get();
        
        $requests_accepted = CustomPartRequest::whereHas('items.itemOffers', function ($query) use ($vendorId) {
                $query->where('vendor_id', $vendorId)
                    ->where('status', 'accepted');
            })
            ->with(['items.itemOffers' => function ($query) use ($vendorId) {
                $query->where('vendor_id', $vendorId)
                    ->where('status', 'accepted');
            },'items'])
            ->get();
       
       
        $requests_completed = CustomPartRequest::whereHas('sparePartOffers', function ($query) use ($vendorId) {
        $query->where('vendor_id', $vendorId)
            ->where('status', 'completed');
        })
        ->with(['sparePartOffers' => function ($query) use ($vendorId) {
            $query->where('vendor_id', $vendorId)
                ->where('status', 'completed');
        },'items'])
        ->get();


       
       return $this->apiResponse(true, 'order for auth retrived successfully not authenticated', [],['pending_request'=>CustomPartRequestResource::collection($requests),'waiting_request'=>CustomPartRequestResource::collection($requests_waiting),'current_request'=>CustomPartRequestResource::collection($requests_accepted),'completed'=>CustomPartRequestResource::collection($requests_completed) ]);

    }
}
