<?php
namespace App\Http\Controllers\Provider;

use Illuminate\Http\Request;
use App\Models\Specialty;
use App\Models\Inspection;
use App\Http\Resources\RepairIssueResource;
use App\Http\Resources\InspectionResource;
use App\Http\Controllers\Controller;
use App\Traits\ApiTrait;
class SpecialtyController extends Controller
{
    // ✅ Store a new inspection
    use ApiTrait;
    public function index(Request $request){
        $specialty = Specialty::all();
        return $this->apiResponse(true, 'specialties retrive successfully', [], RepairIssueResource::collection($specialty));


    }

     public function specialtyInceptions(Request $request){
           
        try {
           
            $specialtyIds = $request->input('specialty_ids', []);

            if (empty($specialtyIds) || !is_array($specialtyIds)) {
                return $this->apiResponse(true, 'Please provide a valid list of specialty IDs', [],[]);
            }

            $inspections = Inspection::whereIn('specialty_id', $specialtyIds)->get();

            return $this->apiResponse(true, 'inceptions retrive successfully', [], InspectionResource::collection($inspections));

        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }
    

}